/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.event;

import net.alshanex.familiarslib.item.AbstractFamiliarSpellbookItem;
import net.alshanex.familiarslib.util.familiars.FamiliarAttributesHelper;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import top.theillusivec4.curios.api.event.CurioChangeEvent;

@EventBusSubscriber(modid="familiarslib", bus=EventBusSubscriber.Bus.GAME)
public class FamiliarAttributesEventHandler {
    @SubscribeEvent
    public static void onCurioEquip(CurioChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (event.getTo().getItem() instanceof AbstractFamiliarSpellbookItem) {
                FamiliarAttributesHelper.handleSpellbookEquipChange(serverPlayer, true);
            }
        }
    }

    @SubscribeEvent
    public static void onCurioUnequip(CurioChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (event.getFrom().getItem() instanceof AbstractFamiliarSpellbookItem) {
                FamiliarAttributesHelper.handleSpellbookEquipChange(serverPlayer, false);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (serverPlayer.tickCount % 20 == 0) {
                FamiliarAttributesHelper.handlePlayerAttributeChange(serverPlayer);
            }
        }
    }
}

