/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.entity;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractTerrestrianSpellCastingPet
extends AbstractSpellCastingPet {
    protected AbstractTerrestrianSpellCastingPet(EntityType<? extends AbstractSpellCastingPet> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = this.createMoveControl();
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(10, (Goal)new MovementAwareRandomStrollGoal(this, 1.0, 60));
    }

    protected void checkFallDamage(double y, boolean onGround, BlockState state, BlockPos pos) {
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
    }

    @Override
    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
    }

    public boolean isDrinkingPotion() {
        return false;
    }

    public void startDrinkingPotion() {
    }

    @Override
    public boolean shouldAlwaysAnimateLegs() {
        return true;
    }

    protected class MovementAwareRandomStrollGoal
    extends Goal {
        public static final int DEFAULT_INTERVAL = 120;
        protected final PathfinderMob mob;
        protected double wantedX;
        protected double wantedY;
        protected double wantedZ;
        protected final double speedModifier;
        protected int interval;
        protected boolean forceTrigger;
        private final boolean checkNoActionTime;

        public MovementAwareRandomStrollGoal(PathfinderMob mob, double speedModifier) {
            this(mob, speedModifier, 120);
        }

        public MovementAwareRandomStrollGoal(PathfinderMob mob, double speedModifier, int interval) {
            this(mob, speedModifier, interval, true);
        }

        public MovementAwareRandomStrollGoal(PathfinderMob mob, double speedModifier, int interval, boolean checkNoActionTime) {
            this.mob = mob;
            this.speedModifier = speedModifier;
            this.interval = interval;
            this.checkNoActionTime = checkNoActionTime;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean canUse() {
            Vec3 vec3;
            if (AbstractTerrestrianSpellCastingPet.this.movementDisabled) {
                return false;
            }
            if (this.mob.hasControllingPassenger()) {
                return false;
            }
            if (!this.forceTrigger) {
                if (this.checkNoActionTime && this.mob.getNoActionTime() >= 100) {
                    return false;
                }
                if (this.mob.getRandom().nextInt(MovementAwareRandomStrollGoal.reducedTickDelay((int)this.interval)) != 0) {
                    return false;
                }
            }
            if ((vec3 = this.getPosition()) == null) {
                return false;
            }
            this.wantedX = vec3.x;
            this.wantedY = vec3.y;
            this.wantedZ = vec3.z;
            this.forceTrigger = false;
            return true;
        }

        @Nullable
        protected Vec3 getPosition() {
            return DefaultRandomPos.getPos((PathfinderMob)this.mob, (int)10, (int)7);
        }

        public boolean canContinueToUse() {
            return !this.mob.getNavigation().isDone() && !this.mob.hasControllingPassenger();
        }

        public void start() {
            this.mob.getNavigation().moveTo(this.wantedX, this.wantedY, this.wantedZ, this.speedModifier);
        }

        public void stop() {
            this.mob.getNavigation().stop();
            super.stop();
        }

        public void trigger() {
            this.forceTrigger = true;
        }

        public void setInterval(int newchance) {
            this.interval = newchance;
        }
    }
}

