/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.entity;

import io.redspace.ironsspellbooks.api.entity.IMagicEntity;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.magic.SpellSelectionManager;
import io.redspace.ironsspellbooks.api.registry.SpellRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellData;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.SyncedSpellData;
import io.redspace.ironsspellbooks.entity.mobs.IMagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericCopyOwnerTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtByTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.GenericOwnerHurtTargetGoal;
import io.redspace.ironsspellbooks.entity.mobs.goals.WizardAttackGoal;
import io.redspace.ironsspellbooks.entity.spells.AoeEntity;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.util.OwnerHelper;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarStorageBlockEntity;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.registry.FParticleRegistry;
import net.alshanex.familiarslib.util.CurioUtils;
import net.alshanex.familiarslib.util.CylinderParticleManager;
import net.alshanex.familiarslib.util.ModTags;
import net.alshanex.familiarslib.util.familiars.FamiliarAnimationUtils;
import net.alshanex.familiarslib.util.familiars.FamiliarAttributesHelper;
import net.alshanex.familiarslib.util.familiars.FamiliarBedHelper;
import net.alshanex.familiarslib.util.familiars.FamiliarDeathStorageHandler;
import net.alshanex.familiarslib.util.familiars.FamiliarGoals;
import net.alshanex.familiarslib.util.familiars.FamiliarHelper;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class AbstractSpellCastingPet
extends PathfinderMob
implements GeoEntity,
IMagicEntity {
    private static final EntityDataAccessor<Boolean> DATA_CANCEL_CAST = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected static final EntityDataAccessor<Boolean> DATA_IS_SITTING;
    protected static final EntityDataAccessor<Boolean> DATA_IS_HOUSE;
    protected final MagicData playerMagicData = new MagicData(true);
    private static final EntityDataAccessor<Optional<UUID>> DATA_ID_OWNER_UUID;
    private static final EntityDataAccessor<Boolean> DATA_BLOCKING;
    private static final EntityDataAccessor<Integer> DATA_ENRAGED;
    private static final EntityDataAccessor<Integer> DATA_ARMOR;
    private static final EntityDataAccessor<Integer> DATA_HEALTH;
    private static final EntityDataAccessor<Boolean> DATA_IMPOSTOR;
    private static final EntityDataAccessor<Boolean> DATA_TOTEM;
    protected LivingEntity cachedSummoner;
    @Nullable
    protected SpellData castingSpell;
    public boolean hasUsedSingleAttack;
    protected boolean recreateSpell;
    protected boolean movementDisabled = false;
    protected static final float DEFAULT_ORIGINAL_MIN_QUALITY = 0.5f;
    protected static final float DEFAULT_ORIGINAL_MAX_QUALITY = 0.7f;
    protected static final float DEFAULT_TRINKET_MIN_QUALITY = 0.7f;
    protected static final float DEFAULT_TRINKET_MAX_QUALITY = 0.9f;
    private boolean lastTrinketState = false;
    private WizardAttackGoal currentAttackGoal;
    private boolean pendingGoalUpdate = false;
    private boolean pendingTrinketState = false;
    private boolean hasAttemptedMigration = false;
    public BlockPos housePosition = null;
    private int bedRegenTimer = 0;
    private boolean wasPlayingSleepAnimation = false;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected AbstractSpell lastCastSpellType = SpellRegistry.none();
    protected AbstractSpell instantCastSpellType = SpellRegistry.none();
    protected boolean cancelCastAnimation = false;
    protected boolean animatingLegs = false;
    protected final RawAnimation idle = RawAnimation.begin().thenLoop("idle");
    protected final RawAnimation walk = RawAnimation.begin().thenLoop("walk");
    protected final RawAnimation attack = RawAnimation.begin().thenPlay("skill");
    protected final RawAnimation longCast = RawAnimation.begin().thenPlay("long_cast");
    protected final RawAnimation interact = RawAnimation.begin().thenPlay("interact");
    protected final RawAnimation stomp = RawAnimation.begin().thenPlay("stomp");
    protected final RawAnimation spawn = RawAnimation.begin().thenPlay("spawn");
    protected final RawAnimation sleep = RawAnimation.begin().thenPlayAndHold("sleep");
    protected final AnimationController animationControllerInstantCast = new AnimationController((GeoAnimatable)this, "instant_casting", 0, this::instantCastingPredicate);
    protected final AnimationController animationControllerLongCast = new AnimationController((GeoAnimatable)this, "long_casting", 0, this::longCastingPredicate);

    protected AbstractSpellCastingPet(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.playerMagicData.setSyncedData(new SyncedSpellData((LivingEntity)this));
        this.lookControl = this.createLookControl();
    }

    protected void setRandomImpostor() {
        Random rand = new Random();
        if ((double)rand.nextFloat() <= 0.1) {
            this.setIsImpostor(true);
            if (this.getIsImpostor().booleanValue()) {
                this.goalSelector.addGoal(3, (Goal)new FamiliarGoals.StealItemsWhenNotWatchedGoal(this, 3.0));
            }
        }
    }

    public boolean getHasUsedSingleAttack() {
        return this.hasUsedSingleAttack;
    }

    public void setHasUsedSingleAttack(boolean hasUsedSingleAttack) {
        this.hasUsedSingleAttack = hasUsedSingleAttack;
    }

    public Vec3 getPassengerRidingPosition(Entity pEntity) {
        return super.getPassengerRidingPosition(pEntity);
    }

    public void rideTick() {
        super.rideTick();
        Entity entity = this.getVehicle();
        if (entity instanceof PathfinderMob) {
            PathfinderMob pathfindermob = (PathfinderMob)entity;
            pathfindermob.yBodyRot = this.yBodyRot;
        }
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new FamiliarGoals.TeleportToOwnerGoal(this, this::getSummoner, 20.0f));
        this.goalSelector.addGoal(7, (Goal)new FamiliarGoals.MovementAwareFollowOwnerGoal(this, this::getSummoner, 1.2f, 10.0f, 3.0f, false, Float.MAX_VALUE));
        this.goalSelector.addGoal(8, (Goal)new FamiliarGoals.MovementAwareLookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(9, (Goal)new FamiliarGoals.MovementAwareRandomLookAroundGoal(this));
        this.goalSelector.addGoal(5, (Goal)new FamiliarGoals.FindAndUsePetBedGoal(this, 10.0));
        this.targetSelector.addGoal(1, (Goal)new GenericOwnerHurtByTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(2, (Goal)new GenericOwnerHurtTargetGoal((Mob)this, this::getSummoner));
        this.targetSelector.addGoal(3, (Goal)new GenericCopyOwnerTargetGoal((PathfinderMob)this, this::getSummoner));
        this.targetSelector.addGoal(4, (Goal)new GenericHurtByTargetGoal((PathfinderMob)this, entity -> entity == this.getSummoner()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(5, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    protected abstract WizardAttackGoal createAttackGoal(float var1, float var2);

    protected float[] getOriginalQualityValues() {
        return new float[]{0.5f, 0.7f};
    }

    protected float[] getTrinketQualityValues() {
        return new float[]{0.7f, 0.9f};
    }

    protected void initializeAttackGoal(int goalPriority) {
        float[] originalValues = this.getOriginalQualityValues();
        this.currentAttackGoal = this.createAttackGoal(originalValues[0], originalValues[1]);
        this.goalSelector.addGoal(goalPriority, (Goal)this.currentAttackGoal);
    }

    private void updateAttackGoal() {
        LivingEntity summoner = this.getSummoner();
        if (summoner == null) {
            return;
        }
        boolean hasTrinket = CurioUtils.isWearingCurio(summoner, this.getValidTrinket());
        if (hasTrinket != this.lastTrinketState) {
            if (this.currentAttackGoal != null && this.currentAttackGoal.isActing()) {
                this.pendingGoalUpdate = true;
                this.pendingTrinketState = hasTrinket;
                return;
            }
            this.updateGoalSafely(hasTrinket);
        }
    }

    private void updateGoalSafely(boolean hasTrinket) {
        if (this.currentAttackGoal != null) {
            this.goalSelector.removeGoal((Goal)this.currentAttackGoal);
        }
        if (hasTrinket) {
            float[] trinketValues = this.getTrinketQualityValues();
            this.currentAttackGoal = this.createAttackGoal(trinketValues[0], trinketValues[1]);
        } else {
            float[] originalValues = this.getOriginalQualityValues();
            this.currentAttackGoal = this.createAttackGoal(originalValues[0], originalValues[1]);
        }
        this.goalSelector.addGoal(2, (Goal)this.currentAttackGoal);
        this.lastTrinketState = hasTrinket;
        this.pendingGoalUpdate = false;
    }

    protected abstract Item getValidTrinket();

    public boolean isAlliedTo(Entity pEntity) {
        return super.isAlliedTo(pEntity) || this.isAlliedHelper(pEntity);
    }

    private boolean isAlliedHelper(Entity entity) {
        LivingEntity owner = this.getSummoner();
        if (owner == null) {
            return false;
        }
        if (entity.is((Entity)this.getSummoner())) {
            return true;
        }
        if (entity instanceof IMagicSummon) {
            IMagicSummon magicSummon = (IMagicSummon)entity;
            Entity otherOwner = magicSummon.getSummoner();
            return otherOwner != null && (owner == otherOwner || otherOwner.isAlliedTo(otherOwner));
        }
        if (entity instanceof OwnableEntity) {
            OwnableEntity tamableAnimal = (OwnableEntity)entity;
            LivingEntity otherOwner = tamableAnimal.getOwner();
            return otherOwner != null && (owner == otherOwner || otherOwner.isAlliedTo((Entity)otherOwner));
        }
        if (entity instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet pet = (AbstractSpellCastingPet)entity;
            LivingEntity otherOwner = pet.getSummoner();
            return otherOwner != null && (owner == otherOwner || otherOwner.isAlliedTo((Entity)otherOwner));
        }
        if (entity instanceof AoeEntity) {
            AoeEntity zone = (AoeEntity)entity;
            Entity otherOwner = zone.getOwner();
            return otherOwner != null && (owner == otherOwner || otherOwner.isAlliedTo(otherOwner) || otherOwner.isAlliedTo((Entity)owner));
        }
        return false;
    }

    public void setOwnerUUID(@Nullable UUID uuid) {
        this.entityData.set(DATA_ID_OWNER_UUID, Optional.ofNullable(uuid));
    }

    public UUID getOwnerUUID() {
        return ((Optional)this.entityData.get(DATA_ID_OWNER_UUID)).orElseGet(() -> ((Optional)this.entityData.get(DATA_ID_OWNER_UUID)).orElse(null));
    }

    public void setEnragedStacks(Integer level) {
        this.entityData.set(DATA_ENRAGED, (Object)level);
    }

    public Integer getEnragedStacks() {
        return (Integer)this.entityData.get(DATA_ENRAGED);
    }

    public void setArmorStacks(Integer level) {
        this.entityData.set(DATA_ARMOR, (Object)level);
    }

    public Integer getArmorStacks() {
        return (Integer)this.entityData.get(DATA_ARMOR);
    }

    public void setHealthStacks(Integer level) {
        this.entityData.set(DATA_HEALTH, (Object)level);
    }

    public Integer getHealthStacks() {
        return (Integer)this.entityData.get(DATA_HEALTH);
    }

    public void setIsBlocking(Boolean level) {
        this.entityData.set(DATA_BLOCKING, (Object)level);
    }

    public Boolean getIsBlocking() {
        return (Boolean)this.entityData.get(DATA_BLOCKING);
    }

    public void setTotem(Boolean level) {
        this.entityData.set(DATA_TOTEM, (Object)level);
    }

    public Boolean getTotem() {
        return (Boolean)this.entityData.get(DATA_TOTEM);
    }

    public void setIsImpostor(Boolean level) {
        this.entityData.set(DATA_IMPOSTOR, (Object)level);
    }

    public Boolean getIsImpostor() {
        return (Boolean)this.entityData.get(DATA_IMPOSTOR);
    }

    public void setSitting(Boolean level) {
        try {
            if (level.booleanValue()) {
                FamiliarBedHelper.snapToExactBedPosition(this);
                this.clearMovementGoals();
                this.navigation.stop();
                this.setTarget(null);
            } else {
                this.restoreMovementGoals();
                this.navigation.recomputePath();
            }
            this.entityData.set(DATA_IS_SITTING, (Object)level);
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error in setSitting: ", (Throwable)e);
        }
    }

    public Boolean getIsSitting() {
        return (Boolean)this.entityData.get(DATA_IS_SITTING);
    }

    public Boolean getIsInHouse() {
        return (Boolean)this.entityData.get(DATA_IS_HOUSE);
    }

    public void setIsInHouse(Boolean level, BlockPos housePos) {
        this.entityData.set(DATA_IS_HOUSE, (Object)level);
        Object object = this.housePosition = level != false ? housePos : null;
        if (level.booleanValue() && housePos != null) {
            this.clearHouseGoals();
            this.addHouseGoals();
            FamiliarsLib.LOGGER.info("Familiar {} entered house mode at {}", (Object)this.getUUID(), (Object)housePos);
        } else {
            this.clearHouseGoals();
            FamiliarsLib.LOGGER.info("Familiar {} exited house mode", (Object)this.getUUID());
        }
    }

    private void addHouseGoals() {
        if (this.housePosition == null) {
            return;
        }
        this.goalSelector.addGoal(1, (Goal)new FamiliarGoals.WanderAroundHouseGoal(this, this.housePosition, 15.0, 1.0));
        this.goalSelector.addGoal(2, (Goal)new FamiliarGoals.CasualLookAtPlayerGoal(this, Player.class, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new FamiliarGoals.CasualRandomLookGoal(this));
        this.goalSelector.addGoal(8, (Goal)new FamiliarGoals.StayNearHouseGoal(this, this.housePosition, 20.0));
        this.goalSelector.addGoal(9, (Goal)new FloatGoal((Mob)this));
    }

    private void clearHouseGoals() {
        this.goalSelector.getAvailableGoals().removeIf(goal -> goal.getGoal() instanceof FamiliarGoals.WanderAroundHouseGoal || goal.getGoal() instanceof FamiliarGoals.StayNearHouseGoal || goal.getGoal() instanceof FamiliarGoals.CasualLookAtPlayerGoal || goal.getGoal() instanceof FamiliarGoals.CasualRandomLookGoal);
    }

    protected void clearMovementGoals() {
        this.movementDisabled = true;
        this.navigation.stop();
    }

    protected void restoreMovementGoals() {
        this.movementDisabled = false;
        this.navigation.recomputePath();
    }

    public boolean hurt(DamageSource pSource, float pAmount) {
        if (this.isInvulnerableTo(pSource)) {
            return false;
        }
        if (!this.level().isClientSide) {
            if (this.wasPlayingSleepAnimation) {
                this.triggerAnim("interact_controller", "interact");
                this.wasPlayingSleepAnimation = false;
                this.bedRegenTimer = 0;
            }
            this.setSitting(false);
        }
        return super.hurt(pSource, pAmount);
    }

    public boolean isInvulnerableTo(DamageSource source) {
        if (source.getEntity() != null && this.isAlliedTo(source.getEntity())) {
            return true;
        }
        return super.isInvulnerableTo(source);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_OWNER_UUID, Optional.empty());
        pBuilder.define(DATA_BLOCKING, (Object)false);
        pBuilder.define(DATA_ENRAGED, (Object)0);
        pBuilder.define(DATA_ARMOR, (Object)0);
        pBuilder.define(DATA_HEALTH, (Object)0);
        pBuilder.define(DATA_CANCEL_CAST, (Object)false);
        pBuilder.define(DATA_IS_SITTING, (Object)false);
        pBuilder.define(DATA_IS_HOUSE, (Object)false);
        pBuilder.define(DATA_IMPOSTOR, (Object)false);
        pBuilder.define(DATA_TOTEM, (Object)false);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> pKey) {
        super.onSyncedDataUpdated(pKey);
        if (!this.level().isClientSide) {
            return;
        }
        if (pKey.id() == DATA_CANCEL_CAST.id()) {
            this.cancelCast();
        }
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        this.playerMagicData.getSyncedData().saveNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        pCompound.putBoolean("usedSpecial", this.hasUsedSingleAttack);
        if (this.getOwnerUUID() != null) {
            pCompound.putUUID("ownerUUID", this.getOwnerUUID());
        } else {
            pCompound.putString("ownerUUID", "null");
        }
        pCompound.putInt("enragedStacks", this.getEnragedStacks().intValue());
        pCompound.putBoolean("isBlocking", this.getIsBlocking().booleanValue());
        pCompound.putInt("armorStacks", this.getArmorStacks().intValue());
        pCompound.putInt("healthStacks", this.getHealthStacks().intValue());
        pCompound.putBoolean("Sitting", this.getIsSitting().booleanValue());
        pCompound.putBoolean("isImpostor", this.getIsImpostor().booleanValue());
        pCompound.putBoolean("hasTotem", this.getTotem().booleanValue());
        pCompound.putInt("bedRegenTimer", this.bedRegenTimer);
        pCompound.putBoolean("wasPlayingSleepAnimation", this.wasPlayingSleepAnimation);
        pCompound.putBoolean("lastTrinketState", this.lastTrinketState);
        pCompound.putBoolean("pendingGoalUpdate", this.pendingGoalUpdate);
        pCompound.putBoolean("pendingTrinketState", this.pendingTrinketState);
        pCompound.putBoolean("hasAttemptedMigration", this.hasAttemptedMigration);
        pCompound.putBoolean("isInHouse", this.getIsInHouse().booleanValue());
        if (this.housePosition != null) {
            pCompound.putLong("housePosition", this.housePosition.asLong());
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        SyncedSpellData syncedSpellData = new SyncedSpellData((LivingEntity)this);
        syncedSpellData.loadNBTData(pCompound, (HolderLookup.Provider)this.level().registryAccess());
        if (syncedSpellData.isCasting()) {
            this.recreateSpell = true;
        }
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.hasUsedSingleAttack = pCompound.getBoolean("usedSpecial");
        if (pCompound.contains("ownerUUID")) {
            String ownerUUIDString = pCompound.getString("ownerUUID");
            if (!"null".equals(ownerUUIDString)) {
                this.setOwnerUUID(pCompound.getUUID("ownerUUID"));
            } else {
                this.setOwnerUUID(null);
            }
        }
        if (pCompound.contains("enragedStacks")) {
            this.setEnragedStacks(pCompound.getInt("enragedStacks"));
        }
        if (pCompound.contains("isBlocking")) {
            this.setIsBlocking(pCompound.getBoolean("isBlocking"));
        }
        if (pCompound.contains("armorStacks")) {
            this.setArmorStacks(pCompound.getInt("armorStacks"));
        }
        if (pCompound.contains("healthStacks")) {
            this.setHealthStacks(pCompound.getInt("healthStacks"));
        }
        if (!this.level().isClientSide) {
            FamiliarAttributesHelper.applyAllConsumableAttributes(this);
            if (pCompound.contains("currentHealth")) {
                float savedHealth = pCompound.getFloat("currentHealth");
                float maxHealth = this.getMaxHealth();
                this.setHealth(Math.min(savedHealth, maxHealth));
                FamiliarsLib.LOGGER.info("Loaded familiar {}: health stacks={}, max health={}, current health={}", new Object[]{this.getUUID(), this.getHealthStacks(), Float.valueOf(maxHealth), Float.valueOf(this.getHealth())});
            }
        }
        if (pCompound.contains("Sitting")) {
            this.setSitting(pCompound.getBoolean("Sitting"));
            this.movementDisabled = pCompound.getBoolean("Sitting");
        }
        if (pCompound.contains("isImpostor")) {
            this.setIsImpostor(pCompound.getBoolean("isImpostor"));
        }
        if (pCompound.contains("hasTotem")) {
            this.setTotem(pCompound.getBoolean("hasTotem"));
        }
        if (pCompound.contains("bedRegenTimer")) {
            this.bedRegenTimer = pCompound.getInt("bedRegenTimer");
        }
        if (pCompound.contains("wasPlayingSleepAnimation")) {
            this.wasPlayingSleepAnimation = pCompound.getBoolean("wasPlayingSleepAnimation");
        }
        this.lastTrinketState = pCompound.getBoolean("lastTrinketState");
        this.pendingGoalUpdate = pCompound.getBoolean("pendingGoalUpdate");
        this.pendingTrinketState = pCompound.getBoolean("pendingTrinketState");
        if (pCompound.contains("hasAttemptedMigration")) {
            this.hasAttemptedMigration = pCompound.getBoolean("hasAttemptedMigration");
        }
        if (pCompound.contains("isInHouse")) {
            boolean inHouse = pCompound.getBoolean("isInHouse");
            BlockPos housePos = null;
            if (pCompound.contains("housePosition")) {
                housePos = BlockPos.of((long)pCompound.getLong("housePosition"));
            }
            this.setIsInHouse(inHouse, housePos);
        }
    }

    public LivingEntity getSummoner() {
        return OwnerHelper.getAndCacheOwner((Level)this.level(), (LivingEntity)this.cachedSummoner, (UUID)this.getOwnerUUID());
    }

    public void die(DamageSource pDamageSource) {
        if (!this.level().isClientSide) {
            this.onDeathHelper();
        }
        if (this.getIsInHouse().booleanValue() && this.housePosition != null) {
            FamiliarDeathStorageHandler.notifyFamiliarDeath(this);
        }
        super.die(pDamageSource);
    }

    private void onDeathHelper() {
        AbstractSpellCastingPet abstractSpellCastingPet = this;
        if (abstractSpellCastingPet instanceof LivingEntity) {
            LivingEntity livingEntity;
            AbstractSpellCastingPet entity = abstractSpellCastingPet;
            Level level = ((LivingEntity)entity).level;
            Component deathMessage = entity.getCombatTracker().getDeathMessage();
            if (!level.isClientSide && level.getGameRules().getBoolean(GameRules.RULE_SHOWDEATHMESSAGES) && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.sendSystemMessage(deathMessage);
            }
        }
    }

    protected LookControl createLookControl() {
        return new LookControl((Mob)this){

            protected boolean resetXRotOnTick() {
                return AbstractSpellCastingPet.this.getTarget() == null;
            }
        };
    }

    protected MoveControl createMoveControl() {
        return new MoveControl(this, (Mob)this){

            protected float rotlerp(float pSourceAngle, float pTargetAngle, float pMaximumChange) {
                double d1;
                double d0 = this.wantedX - this.mob.getX();
                if (d0 * d0 + (d1 = this.wantedZ - this.mob.getZ()) * d1 < 0.5) {
                    return pSourceAngle;
                }
                return super.rotlerp(pSourceAngle, pTargetAngle, pMaximumChange * 0.25f);
            }
        };
    }

    public MagicData getMagicData() {
        return this.playerMagicData;
    }

    public void tick() {
        UUID ownerUUID;
        ServerPlayer serverPlayer;
        super.tick();
        if (this.level().isClientSide) {
            this.noCulling = this.isAnimating();
        }
        if (!this.level().isClientSide && this.getIsInHouse().booleanValue()) {
            FamiliarHelper.handleHouseBehavior(this);
        }
        if (!this.level().isClientSide && !this.hasAttemptedMigration && this.getSummoner() != null) {
            LivingEntity livingEntity = this.getSummoner();
            if (livingEntity instanceof ServerPlayer) {
                serverPlayer = (ServerPlayer)livingEntity;
                FamiliarHelper.attemptLegacyMigration(serverPlayer, this);
                this.hasAttemptedMigration = true;
            } else {
                ServerLevel serverLevel;
                ServerPlayer serverPlayer2;
                Level level;
                ownerUUID = this.getOwnerUUID();
                if (ownerUUID != null && (level = this.level()) instanceof ServerLevel && (serverPlayer2 = (serverLevel = (ServerLevel)level).getServer().getPlayerList().getPlayer(ownerUUID)) != null) {
                    FamiliarHelper.attemptLegacyMigration(serverPlayer2, this);
                    this.hasAttemptedMigration = true;
                }
            }
        }
        if (!(!this.pendingGoalUpdate || this.level.isClientSide || this.currentAttackGoal != null && this.currentAttackGoal.isActing())) {
            this.updateGoalSafely(this.pendingTrinketState);
        }
        if (this.tickCount % 20 == 0 && !this.level.isClientSide) {
            this.updateAttackGoal();
        }
        if (!(this.tickCount % 600 != 0 || this.level.isClientSide || this.getSummoner() == null && this.getOwnerUUID() == null)) {
            this.setPersistenceRequired();
        }
        if (this.getSummoner() != null && this.getTarget() != null && (ownerUUID = this.getTarget()) instanceof AbstractSpellCastingPet) {
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)((Object)ownerUUID);
            if (this.tickCount % 10 == 0 && familiar.getSummoner() != null && familiar.getSummoner().is((Entity)this.getSummoner())) {
                this.setTarget(null);
            }
        }
        if (this.getTarget() != null && this.getIsInHouse().booleanValue() && this.tickCount % 10 == 0) {
            if (this.isHunterPet()) {
                ownerUUID = this.getTarget();
                if (ownerUUID instanceof Mob) {
                    Mob mob = (Mob)ownerUUID;
                    if (mob.getTarget() != null && this.isAlliedTo((Entity)mob.getTarget()) && !mob.getTarget().getType().is(ModTags.HUNTER_CANNOT_ATTACK_IN_HOME)) {
                        this.setTarget((LivingEntity)mob);
                    } else {
                        this.setTarget(null);
                    }
                } else {
                    this.setTarget(null);
                }
            } else {
                this.setTarget(null);
            }
        }
        this.handleBedRegeneration();
        if (this.getSummoner() != null && this.tickCount % 10 == 0 && this.getHealth() > 0.0f) {
            if (CurioUtils.isWearingFamiliarSpellbook(this.getSummoner())) {
                FamiliarAttributesHelper.applyAttributes(this);
            } else {
                FamiliarAttributesHelper.removeAttributes(this);
            }
        }
        if (this.getSummoner() != null && this.tickCount % 40 == 0 && !this.level().isClientSide && (ownerUUID = this.getSummoner()) instanceof ServerPlayer) {
            serverPlayer = (ServerPlayer)ownerUUID;
            PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            if (familiarData.hasFamiliar(this.getUUID())) {
                FamiliarManager.updateFamiliarData(this);
            } else {
                FamiliarsLib.LOGGER.debug("Familiar {} not in player data, skipping update", (Object)this.getUUID());
            }
        }
    }

    private void handleBedRegeneration() {
        boolean shouldPlaySleepAnimation;
        boolean isOnValidBed = FamiliarBedHelper.isOnCompatibleBed(this);
        boolean bl = shouldPlaySleepAnimation = this.getIsSitting() != false && isOnValidBed;
        if (shouldPlaySleepAnimation) {
            if (!this.wasPlayingSleepAnimation && !this.level().isClientSide) {
                FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.getUUID()) + " starting sleep animation on compatible bed");
            }
            if (!this.level().isClientSide) {
                ++this.bedRegenTimer;
                if (this.bedRegenTimer >= 20) {
                    if (this.getHealth() < this.getMaxHealth()) {
                        this.heal(1.0f);
                        FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.getUUID()) + " healed to " + this.getHealth() + "/" + this.getMaxHealth());
                        CylinderParticleManager.spawnParticlesAtBlockPos(this.level(), this.position(), 1, (ParticleOptions)FParticleRegistry.SLEEP_PARTICLE.get(), CylinderParticleManager.ParticleDirection.UPWARD, 0.1, 0.0, 0.8);
                    } else {
                        this.setSitting(false);
                        FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.getUUID()) + " fully healed, stopping sleep");
                    }
                    this.bedRegenTimer = 0;
                }
            }
        } else {
            if (this.wasPlayingSleepAnimation && !this.level().isClientSide) {
                FamiliarsLib.LOGGER.debug("Pet " + String.valueOf(this.getUUID()) + " stopping sleep animation - not on valid bed or not sitting");
            }
            if (this.bedRegenTimer > 0) {
                this.bedRegenTimer = 0;
            }
        }
    }

    public static AttributeSupplier.Builder prepareAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.ATTACK_DAMAGE, 3.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.MAX_HEALTH, 50.0).add(Attributes.FOLLOW_RANGE, 24.0).add(Attributes.MOVEMENT_SPEED, 0.25);
    }

    public boolean canBeLeashed() {
        return false;
    }

    public void checkDespawn() {
        if (this.getSummoner() != null || this.getOwnerUUID() != null) {
            this.setPersistenceRequired();
            return;
        }
        super.checkDespawn();
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        if (this.getSummoner() != null || this.getOwnerUUID() != null) {
            return false;
        }
        return super.removeWhenFarAway(distanceToClosestPlayer);
    }

    public boolean requiresCustomPersistence() {
        return this.getSummoner() != null || this.getOwnerUUID() != null;
    }

    protected boolean shouldDespawnInPeaceful() {
        return false;
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (this.getIsInHouse().booleanValue() && this.housePosition != null) {
            BlockEntity blockEntity = this.level().getBlockEntity(this.housePosition);
            if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
                return InteractionResult.FAIL;
            }
            AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
            if (!storageEntity.isOwner((ServerPlayer)player)) {
                return InteractionResult.FAIL;
            }
            if (!this.level().isClientSide && this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                this.heal(4.0f);
                itemstack.consume(1, (LivingEntity)player);
                FamiliarHelper.spawnEatingParticles(this);
                this.gameEvent((Holder)GameEvent.EAT);
                return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
            }
            return InteractionResult.PASS;
        }
        if (this.getSummoner() != null && this.getSummoner().is((Entity)player) && itemstack.is(Items.STICK)) {
            this.setSitting(this.getIsSitting() == false);
            return InteractionResult.SUCCESS;
        }
        if (!this.level().isClientSide) {
            if (this.getOwnerUUID() != null) {
                if (this.getOwnerUUID().equals(player.getUUID())) {
                    LivingEntity livingEntity = this.getSummoner();
                    if (livingEntity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
                        FamiliarHelper.attemptLegacyMigration(serverPlayer, this);
                    }
                    if (!this.wasPlayingSleepAnimation) {
                        this.triggerAnim("interact_controller", "interact");
                    }
                    if (itemstack.is(ModTags.BERRY)) {
                        itemstack.shrink(1);
                        Optional<Item> firstItem = BuiltInRegistries.ITEM.getTag(ModTags.FRAGMENTS).map(holders -> (Item)((Holder)holders.iterator().next()).value()).or(() -> Optional.empty());
                        ItemStack itemStack = firstItem.map(item -> new ItemStack((ItemLike)item, 1)).orElse(ItemStack.EMPTY);
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), itemStack));
                        if (this.getHealth() < this.getMaxHealth()) {
                            this.heal(4.0f);
                            this.gameEvent((Holder)GameEvent.EAT);
                        }
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    if (this.isFood(itemstack) && this.getHealth() < this.getMaxHealth()) {
                        this.heal(4.0f);
                        itemstack.consume(1, (LivingEntity)player);
                        FamiliarHelper.spawnEatingParticles(this);
                        this.gameEvent((Holder)GameEvent.EAT);
                        return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
                    }
                    if (this.isHunterPet() && itemstack != null && itemstack != ItemStack.EMPTY) {
                        Item heldItem = itemstack.getItem();
                        AABB searchArea = this.getBoundingBox().inflate(20.0);
                        List nearbyEntities = this.level().getEntities((Entity)this, searchArea, entity -> entity instanceof LivingEntity && FamiliarHelper.canDropItem((ServerLevel)this.level(), entity, heldItem) && !entity.getType().is(ModTags.HUNTER_CANNOT_MARK));
                        for (Entity entity2 : nearbyEntities) {
                            if (!(entity2 instanceof LivingEntity)) continue;
                            LivingEntity livingEntity2 = (LivingEntity)entity2;
                            livingEntity2.addEffect(new MobEffectInstance(MobEffects.GLOWING, 200, 0, false, true));
                        }
                        return super.mobInteract(player, hand);
                    }
                }
            } else if (itemstack.is(ModTags.FAMILIAR_TAMING)) {
                itemstack.consume(1, (LivingEntity)player);
                this.tryToTame(player);
                return InteractionResult.SUCCESS;
            }
        }
        return super.mobInteract(player, hand);
    }

    protected boolean isHunterPet() {
        return false;
    }

    protected void clericSetGoal(ServerPlayer player) {
    }

    protected boolean isFood(ItemStack item) {
        return item.is(Items.APPLE);
    }

    protected void tryToTame(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (!familiarData.canTameMoreFamiliars()) {
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.limit_familiars", (Object[])new Object[]{10}).withStyle(ChatFormatting.RED)));
            return;
        }
        if (this.random.nextInt(10) <= 3) {
            FamiliarHelper.spawnTamingParticles(true, this);
            this.navigation.stop();
            this.setTarget(null);
            this.setOwnerUUID(player.getUUID());
            boolean success = FamiliarManager.handleFamiliarTaming(this, serverPlayer);
            if (success) {
                this.setPersistenceRequired();
                this.triggerAdvancement(serverPlayer);
                int remainingSlots = familiarData.getRemainingFamiliarSlots();
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.tamed_successfully", (Object[])new Object[]{remainingSlots}).withStyle(ChatFormatting.WHITE)));
                serverPlayer.level().playSound(null, serverPlayer.getX(), serverPlayer.getY(), serverPlayer.getZ(), SoundEvents.PLAYER_LEVELUP, SoundSource.PLAYERS, 0.5f, 2.0f);
                this.clericSetGoal(serverPlayer);
            } else {
                FamiliarHelper.spawnTamingParticles(false, this);
            }
        } else {
            FamiliarHelper.spawnTamingParticles(false, this);
        }
    }

    protected void triggerAdvancement(ServerPlayer player) {
    }

    public void onAddedToLevel() {
        super.onAddedToLevel();
        this.triggerAnim("spawn_controller", "spawn");
        if (!(this.level().isClientSide || this.getHealthStacks() <= 0 && this.getArmorStacks() <= 0)) {
            FamiliarAttributesHelper.applyAllConsumableAttributes(this);
            FamiliarsLib.LOGGER.debug("Applied attributes on level join for familiar {}: {} health stacks, {} armor stacks", new Object[]{this.getUUID(), this.getHealthStacks(), this.getArmorStacks()});
        }
    }

    public void onRemovedFromLevel() {
        LivingEntity livingEntity;
        super.onRemovedFromLevel();
        if (!this.level.isClientSide && (livingEntity = this.getSummoner()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            FamiliarAttributesHelper.handleFamiliarDismissed(serverPlayer, this);
        }
        if (!this.level.isClientSide) {
            MagicManager.spawnParticles((Level)this.level(), (ParticleOptions)ParticleTypes.POOF, (double)this.getX(), (double)this.getY(), (double)this.getZ(), (int)25, (double)0.4, (double)0.8, (double)0.4, (double)0.03, (boolean)false);
        }
    }

    public boolean canExecuteGoalsInHouse() {
        if (!this.getIsInHouse().booleanValue() || this.housePosition == null) {
            return true;
        }
        if (this.level() == null || this.level().isClientSide) {
            return false;
        }
        BlockEntity blockEntity = this.level().getBlockEntity(this.housePosition);
        if (!(blockEntity instanceof AbstractFamiliarStorageBlockEntity)) {
            return false;
        }
        AbstractFamiliarStorageBlockEntity storageEntity = (AbstractFamiliarStorageBlockEntity)blockEntity;
        return !storageEntity.isStoreMode() && storageEntity.canFamiliarsUseGoals();
    }

    public boolean getMovementDisabled() {
        return this.movementDisabled;
    }

    public void cancelCast() {
        if (this.isCasting()) {
            if (this.level().isClientSide) {
                this.cancelCastAnimation = true;
            } else {
                this.entityData.set(DATA_CANCEL_CAST, (Object)((Boolean)this.entityData.get(DATA_CANCEL_CAST) == false ? 1 : 0));
            }
            this.castComplete();
        }
    }

    public void castComplete() {
        if (!this.level().isClientSide) {
            if (this.castingSpell != null) {
                this.castingSpell.getSpell().onServerCastComplete(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData, false);
            }
        } else {
            this.playerMagicData.resetCastingState();
        }
        this.castingSpell = null;
    }

    public void setSyncedSpellData(SyncedSpellData syncedSpellData) {
        if (!this.level().isClientSide) {
            return;
        }
        boolean isCasting = this.playerMagicData.isCasting();
        this.playerMagicData.setSyncedData(syncedSpellData);
        this.castingSpell = this.playerMagicData.getCastingSpell();
        if (this.castingSpell == null) {
            return;
        }
        if (!this.playerMagicData.isCasting() && isCasting) {
            this.castComplete();
        } else if (this.playerMagicData.isCasting() && !isCasting) {
            AbstractSpell spell = this.playerMagicData.getCastingSpell().getSpell();
            this.initiateCastSpell(spell, this.playerMagicData.getCastingSpellLevel());
            if (this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.instantCastSpellType = this.castingSpell.getSpell();
                this.castingSpell.getSpell().onClientPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, InteractionHand.MAIN_HAND, this.playerMagicData);
                this.castComplete();
            }
        }
    }

    protected void customServerAiStep() {
        super.customServerAiStep();
        if (this.recreateSpell) {
            this.recreateSpell = false;
            SyncedSpellData syncedSpellData = this.playerMagicData.getSyncedData();
            this.setSyncedSpellData(syncedSpellData);
        }
        if (this.castingSpell == null) {
            return;
        }
        this.playerMagicData.handleCastDuration();
        if (this.playerMagicData.isCasting()) {
            this.castingSpell.getSpell().onServerCastTick(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
        this.forceLookAtTarget(this.getTarget());
        if (this.playerMagicData.getCastDurationRemaining() <= 0) {
            if (this.castingSpell.getSpell().getCastType() == CastType.LONG || this.castingSpell.getSpell().getCastType() == CastType.INSTANT) {
                this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
            }
            this.castComplete();
        } else if (this.castingSpell.getSpell().getCastType() == CastType.CONTINUOUS && (this.playerMagicData.getCastDurationRemaining() + 1) % 10 == 0) {
            this.castingSpell.getSpell().onCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, CastSource.MOB, this.playerMagicData);
        }
    }

    public void initiateCastSpell(AbstractSpell spell, int spellLevel) {
        if (spell == SpellRegistry.none()) {
            this.castingSpell = null;
            return;
        }
        if (this.level().isClientSide) {
            this.cancelCastAnimation = false;
        }
        this.castingSpell = new SpellData(spell, spellLevel);
        if (this.getTarget() != null) {
            this.forceLookAtTarget(this.getTarget());
        }
        if (!this.level().isClientSide && !this.castingSpell.getSpell().checkPreCastConditions(this.level(), spellLevel, (LivingEntity)this, this.playerMagicData)) {
            this.castingSpell = null;
            return;
        }
        if (spell == SpellRegistry.TELEPORT_SPELL.get() || spell == SpellRegistry.FROST_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(10);
        } else if (spell == SpellRegistry.BLOOD_STEP_SPELL.get()) {
            this.setTeleportLocationBehindTarget(3);
        } else if (spell == SpellRegistry.BURNING_DASH_SPELL.get()) {
            this.setBurningDashDirectionData();
        }
        this.playerMagicData.initiateCast(this.castingSpell.getSpell(), this.castingSpell.getLevel(), this.castingSpell.getSpell().getEffectiveCastTime(this.castingSpell.getLevel(), (LivingEntity)this), CastSource.MOB, SpellSelectionManager.MAINHAND);
        if (!this.level().isClientSide) {
            this.castingSpell.getSpell().onServerPreCast(this.level(), this.castingSpell.getLevel(), (LivingEntity)this, this.playerMagicData);
        }
    }

    public void notifyDangerousProjectile(Projectile projectile) {
    }

    public boolean isCasting() {
        return this.playerMagicData.isCasting();
    }

    public boolean setTeleportLocationBehindTarget(int distance) {
        LivingEntity target = this.getTarget();
        boolean valid = false;
        if (target != null) {
            Vec3 rotation = target.getLookAngle().normalize().scale((double)(-distance));
            Vec3 pos = target.position();
            Vec3 teleportPos = rotation.add(pos);
            for (int i = 0; i < 24; ++i) {
                Vec3 randomness = Utils.getRandomVec3((double)(0.15f * (float)i)).multiply(1.0, 0.0, 1.0);
                teleportPos = Utils.moveToRelativeGroundLevel((Level)this.level(), (Vec3)target.position().subtract(new Vec3(0.0, 0.0, (double)((float)distance / (float)(i / 7 + 1))).yRot(-(target.getYRot() + (float)(i * 45)) * ((float)Math.PI / 180))).add(randomness), (int)5);
                teleportPos = new Vec3(teleportPos.x, teleportPos.y + (double)0.1f, teleportPos.z);
                AABB reposBB = this.getBoundingBox().move(teleportPos.subtract(this.position()));
                if (this.level().collidesWithSuffocatingBlock((Entity)this, reposBB.inflate((double)-0.05f))) continue;
                valid = true;
                break;
            }
            if (valid) {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(teleportPos));
            } else {
                this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
            }
        } else {
            this.playerMagicData.setAdditionalCastData((ICastData)new TeleportSpell.TeleportData(this.position()));
        }
        return valid;
    }

    public void setBurningDashDirectionData() {
        this.playerMagicData.setAdditionalCastData((ICastData)new BurningDashSpell.BurningDashDirectionOverrideCastData());
    }

    protected void forceLookAtTarget(LivingEntity target) {
        if (target != null) {
            double d0 = target.getX() - this.getX();
            double d2 = target.getZ() - this.getZ();
            double d1 = target.getEyeY() - this.getEyeY();
            double d3 = Math.sqrt(d0 * d0 + d2 * d2);
            float f = (float)(Mth.atan2((double)d2, (double)d0) * 57.2957763671875) - 90.0f;
            float f1 = (float)(-(Mth.atan2((double)d1, (double)d3) * 57.2957763671875));
            this.setXRot(f1 % 360.0f);
            this.setYRot(f % 360.0f);
        }
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(this.animationControllerInstantCast);
        controllerRegistrar.add(this.animationControllerLongCast);
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "idle", 0, this::idlePredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "sleep", 0, this::sleepPredicate));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "interact_controller", state -> PlayState.STOP).triggerableAnim("interact", this.interact));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "spawn_controller", state -> PlayState.STOP).triggerableAnim("spawn", this.spawn));
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "block_controller", state -> PlayState.STOP).triggerableAnim("block", this.attack));
    }

    protected PlayState idlePredicate(AnimationState event) {
        if (this.isAnimating()) {
            return PlayState.STOP;
        }
        if (event.isMoving()) {
            event.getController().setAnimation(this.walk);
            return PlayState.CONTINUE;
        }
        if (!event.isMoving()) {
            event.getController().setAnimation(this.idle);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    protected PlayState sleepPredicate(AnimationState event) {
        boolean shouldPlaySleepAnimation;
        boolean isOnValidBed = FamiliarBedHelper.isOnCompatibleBed(this);
        boolean bl = shouldPlaySleepAnimation = this.getIsSitting() != false && isOnValidBed;
        if (shouldPlaySleepAnimation) {
            if (!this.wasPlayingSleepAnimation) {
                this.wasPlayingSleepAnimation = true;
                event.getController().setAnimation(this.sleep);
                return PlayState.CONTINUE;
            }
            return PlayState.CONTINUE;
        }
        if (this.wasPlayingSleepAnimation) {
            this.wasPlayingSleepAnimation = false;
            return PlayState.STOP;
        }
        return PlayState.STOP;
    }

    protected PlayState instantCastingPredicate(AnimationState event) {
        if (this.cancelCastAnimation) {
            return PlayState.STOP;
        }
        AnimationController controller = event.getController();
        if (this.instantCastSpellType != SpellRegistry.none() && controller.getAnimationState() == AnimationController.State.STOPPED) {
            if (this.castingSpell != null) {
                this.setStartAnimationFromSpell(controller, this.instantCastSpellType, this.castingSpell.getLevel());
            } else {
                this.setStartAnimationFromSpell(controller, this.instantCastSpellType, 1);
            }
            this.instantCastSpellType = SpellRegistry.none();
        }
        return PlayState.CONTINUE;
    }

    protected PlayState longCastingPredicate(AnimationState event) {
        AnimationController controller = event.getController();
        if (this.cancelCastAnimation || controller.getAnimationState() == AnimationController.State.STOPPED && (!this.isCasting() || this.castingSpell == null || this.castingSpell.getSpell().getCastType() != CastType.LONG)) {
            return PlayState.STOP;
        }
        if (this.isCasting() && controller.getAnimationState() == AnimationController.State.STOPPED && this.castingSpell != null) {
            this.setStartAnimationFromSpell(controller, this.castingSpell.getSpell(), this.castingSpell.getLevel());
        }
        return PlayState.CONTINUE;
    }

    protected void setStartAnimationFromSpell(AnimationController controller, AbstractSpell spell, int spellLevel) {
        spell.getCastStartAnimation().getForMob().ifPresentOrElse(animationBuilder -> {
            controller.forceAnimationReset();
            if (FamiliarAnimationUtils.isLongAnimCast(spell, spellLevel)) {
                controller.setAnimation(this.longCast);
            } else if (spell == SpellRegistry.STOMP_SPELL.get()) {
                controller.setAnimation(this.stomp);
            } else {
                controller.setAnimation(this.attack);
            }
            this.lastCastSpellType = spell;
            this.cancelCastAnimation = false;
            this.animatingLegs = false;
        }, () -> {
            this.cancelCastAnimation = true;
        });
    }

    public boolean isAnimating() {
        return this.isCasting() || this.animationControllerLongCast.getAnimationState() != AnimationController.State.STOPPED || this.animationControllerInstantCast.getAnimationState() != AnimationController.State.STOPPED || this.wasPlayingSleepAnimation;
    }

    public boolean shouldAlwaysAnimateHead() {
        return false;
    }

    public boolean shouldPointArmsWhileCasting() {
        return false;
    }

    public boolean shouldBeExtraAnimated() {
        return true;
    }

    public boolean shouldAlwaysAnimateLegs() {
        return !this.animatingLegs;
    }

    public boolean bobBodyWhileWalking() {
        return true;
    }

    public boolean shouldSheathSword() {
        return false;
    }

    static {
        DATA_ID_OWNER_UUID = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
        DATA_BLOCKING = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_ENRAGED = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_ARMOR = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_HEALTH = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.INT);
        DATA_IS_SITTING = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IS_HOUSE = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_IMPOSTOR = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
        DATA_TOTEM = SynchedEntityData.defineId(AbstractSpellCastingPet.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    }
}

