/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.data;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class BedLinkData
implements INBTSerializable<CompoundTag> {
    private final Map<UUID, BlockPos> familiarToBed = new HashMap<UUID, BlockPos>();
    private final Map<BlockPos, UUID> bedToFamiliar = new HashMap<BlockPos, UUID>();

    public void linkFamiliarToBed(UUID familiarId, BlockPos bedPos) {
        this.unlinkFamiliar(familiarId);
        this.unlinkBed(bedPos);
        this.familiarToBed.put(familiarId, bedPos);
        this.bedToFamiliar.put(bedPos, familiarId);
    }

    public void unlinkFamiliar(UUID familiarId) {
        BlockPos bedPos = this.familiarToBed.remove(familiarId);
        if (bedPos != null) {
            this.bedToFamiliar.remove(bedPos);
        }
    }

    public void unlinkBed(BlockPos bedPos) {
        UUID familiarId = this.bedToFamiliar.remove(bedPos);
        if (familiarId != null) {
            this.familiarToBed.remove(familiarId);
        }
    }

    public BlockPos getLinkedBed(UUID familiarId) {
        return this.familiarToBed.get(familiarId);
    }

    public UUID getLinkedFamiliar(BlockPos bedPos) {
        return this.bedToFamiliar.get(bedPos);
    }

    public boolean isFamiliarLinked(UUID familiarId) {
        return this.familiarToBed.containsKey(familiarId);
    }

    public boolean isBedLinked(BlockPos bedPos) {
        return this.bedToFamiliar.containsKey(bedPos);
    }

    public Map<UUID, BlockPos> getAllLinks() {
        return new HashMap<UUID, BlockPos>(this.familiarToBed);
    }

    public void clearAllLinks() {
        this.familiarToBed.clear();
        this.bedToFamiliar.clear();
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag nbt = new CompoundTag();
        ListTag linksList = new ListTag();
        for (Map.Entry<UUID, BlockPos> entry : this.familiarToBed.entrySet()) {
            CompoundTag linkEntry = new CompoundTag();
            linkEntry.putUUID("familiarId", entry.getKey());
            linkEntry.putLong("bedPos", entry.getValue().asLong());
            linksList.add((Object)linkEntry);
        }
        nbt.put("links", (Tag)linksList);
        return nbt;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        this.clearAllLinks();
        if (nbt.contains("links", 9)) {
            ListTag linksList = nbt.getList("links", 10);
            for (int i = 0; i < linksList.size(); ++i) {
                CompoundTag linkEntry = linksList.getCompound(i);
                if (!linkEntry.hasUUID("familiarId") || !linkEntry.contains("bedPos")) continue;
                UUID familiarId = linkEntry.getUUID("familiarId");
                BlockPos bedPos = BlockPos.of((long)linkEntry.getLong("bedPos"));
                this.linkFamiliarToBed(familiarId, bedPos);
            }
        }
    }
}

