/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFamiliarStorageBlockEntity
extends BlockEntity {
    private static final int MAX_STORED_FAMILIARS = 10;
    private static final int MIN_OCCUPATION_TICKS = 100;
    private static final int RELEASE_CHANCE_PER_TICK = 40;
    private static final int DEFAULT_MAX_DISTANCE = 25;
    private int ticksSinceLastRelease = 0;
    private static final int MAX_TICKS_WITHOUT_RELEASE = 400;
    private boolean wasNightTime = false;
    private int dayNightTransitionCooldown = 0;
    private static final int TRANSITION_COOLDOWN_TICKS = 200;
    private UUID ownerUUID;
    public final Map<UUID, FamiliarData> storedFamiliars = new HashMap<UUID, FamiliarData>();
    public final Set<UUID> outsideFamiliars = new HashSet<UUID>();
    private boolean storeMode = true;
    private boolean canFamiliarsUseGoals = true;
    private int maxDistance = 25;

    public AbstractFamiliarStorageBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, AbstractFamiliarStorageBlockEntity storageEntity) {
        storageEntity.tick();
    }

    protected void tick() {
        boolean isNight;
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        boolean bl = isNight = !this.isDaytime();
        if (this.dayNightTransitionCooldown > 0) {
            --this.dayNightTransitionCooldown;
        }
        if (isNight && !this.wasNightTime && !this.storeMode && this.dayNightTransitionCooldown == 0) {
            this.recallAllOutsideFamiliars();
            this.dayNightTransitionCooldown = 200;
        }
        if (this.dayNightTransitionCooldown == 0 || !isNight) {
            this.wasNightTime = isNight;
        }
        if (this.storeMode) {
            this.cleanupMissingFamiliars();
            return;
        }
        if (isNight) {
            this.cleanupMissingFamiliars();
            this.handleDistantFamiliars();
            return;
        }
        if (!this.storedFamiliars.isEmpty()) {
            ++this.ticksSinceLastRelease;
            if (this.level.random.nextInt(40) == 0 && this.releaseRandomFamiliar()) {
                this.ticksSinceLastRelease = 0;
            }
            if (this.ticksSinceLastRelease >= 400 && this.releaseRandomFamiliar()) {
                this.ticksSinceLastRelease = 0;
            }
            if (this.storedFamiliars.size() >= 3 && this.level.random.nextInt(80) == 0) {
                this.releaseRandomFamiliar();
            }
            if (this.level.random.nextInt(60) == 0) {
                this.releaseRandomFamiliar();
            }
        } else {
            this.ticksSinceLastRelease = 0;
        }
        this.cleanupMissingFamiliars();
        this.handleDistantFamiliars();
    }

    public boolean isStoreMode() {
        return this.storeMode;
    }

    public void setStoreMode(boolean storeMode) {
        if (this.storeMode != storeMode) {
            this.storeMode = storeMode;
            if (storeMode) {
                this.recallAllOutsideFamiliars();
            }
            this.setChanged();
            this.syncToClient();
            FamiliarsLib.LOGGER.debug("Storage mode changed to: {}", (Object)(storeMode ? "Store" : "Wander"));
        }
    }

    public boolean canFamiliarsUseGoals() {
        return this.canFamiliarsUseGoals;
    }

    public void setCanFamiliarsUseGoals(boolean canFamiliarsUseGoals) {
        if (this.canFamiliarsUseGoals != canFamiliarsUseGoals) {
            this.canFamiliarsUseGoals = canFamiliarsUseGoals;
            this.setChanged();
            this.syncToClient();
            FamiliarsLib.LOGGER.debug("Can familiars use goals changed to: {}", (Object)canFamiliarsUseGoals);
        }
    }

    public int getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(int maxDistance) {
        this.maxDistance = Math.max(3, Math.min(25, maxDistance));
        this.setChanged();
        this.syncToClient();
        FamiliarsLib.LOGGER.debug("Max distance changed to: {}", (Object)this.maxDistance);
    }

    protected void recallAllOutsideFamiliars() {
        if (this.outsideFamiliars.isEmpty()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        HashSet<UUID> familiarsToRecall = new HashSet<UUID>(this.outsideFamiliars);
        for (UUID familiarId : familiarsToRecall) {
            Entity entity = serverLevel.getEntity(familiarId);
            if (!(entity instanceof AbstractSpellCastingPet)) continue;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            CompoundTag nbtData = FamiliarManager.createFamiliarNBT(familiar);
            FamiliarData data = new FamiliarData(nbtData, 0);
            this.storedFamiliars.put(familiarId, data);
            familiar.remove(Entity.RemovalReason.DISCARDED);
            FamiliarsLib.LOGGER.debug("Recalled familiar {} due to Store Mode activation or nighttime", (Object)familiarId);
        }
        this.outsideFamiliars.clear();
    }

    protected boolean releaseRandomFamiliar() {
        if (!this.isDaytime()) {
            return false;
        }
        if (this.dayNightTransitionCooldown > 0) {
            return false;
        }
        if (this.storeMode || this.storedFamiliars.isEmpty()) {
            return false;
        }
        ArrayList<UUID> availableFamiliars = new ArrayList<UUID>();
        for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
            if (!entry.getValue().canBeReleased()) continue;
            availableFamiliars.add(entry.getKey());
        }
        if (availableFamiliars.isEmpty()) {
            for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
                if (entry.getValue().occupationTime < 100) continue;
                availableFamiliars.add(entry.getKey());
            }
        }
        if (availableFamiliars.isEmpty() && !this.storedFamiliars.isEmpty()) {
            availableFamiliars.addAll(this.storedFamiliars.keySet());
        }
        if (!availableFamiliars.isEmpty()) {
            UUID familiarToRelease = (UUID)availableFamiliars.get(this.level.random.nextInt(availableFamiliars.size()));
            this.releaseFamiliar(familiarToRelease);
            return true;
        }
        return false;
    }

    protected void releaseFamiliar(UUID familiarId) {
        if (!this.isDaytime()) {
            return;
        }
        if (this.dayNightTransitionCooldown > 0) {
            return;
        }
        FamiliarData familiarData = this.storedFamiliars.get(familiarId);
        if (familiarData == null) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        String entityTypeString = familiarData.nbtData.getString("id");
        EntityType entityType = EntityType.byString((String)entityTypeString).orElse(null);
        if (entityType == null) {
            FamiliarsLib.LOGGER.debug("Unknown entity type: {}", (Object)entityTypeString);
            return;
        }
        Entity entity = entityType.create((Level)serverLevel);
        if (!(entity instanceof AbstractSpellCastingPet)) {
            FamiliarsLib.LOGGER.debug("Entity is not a familiar: {}", (Object)entity);
            return;
        }
        AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
        familiar.load(familiarData.nbtData);
        familiar.setUUID(familiarId);
        float savedHealth = familiarData.nbtData.getFloat("currentHealth");
        familiar.setHealth(Math.min(savedHealth, familiar.getMaxHealth()));
        Vec3 spawnPos = this.findSafeReleasePosition();
        if (spawnPos == null) {
            return;
        }
        familiar.setPos(spawnPos.x, spawnPos.y, spawnPos.z);
        familiar.setYRot(this.level.random.nextFloat() * 360.0f);
        familiar.setOldPosAndRot();
        familiar.setIsInHouse(true, this.getBlockPos());
        serverLevel.addFreshEntity((Entity)familiar);
        serverLevel.playSound(null, spawnPos.x, spawnPos.y, spawnPos.z, SoundEvents.BEEHIVE_EXIT, SoundSource.BLOCKS, 1.0f, 1.0f);
        serverLevel.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)familiar, (BlockState)this.getBlockState()));
        this.storedFamiliars.remove(familiarId);
        this.outsideFamiliars.add(familiarId);
        this.setChanged();
        this.syncToClient();
        FamiliarsLib.LOGGER.debug("Released familiar {} from storage at {}", (Object)familiarId, (Object)this.getBlockPos());
    }

    protected void cleanupMissingFamiliars() {
        if (this.outsideFamiliars.isEmpty()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        HashSet<UUID> familiarsToRemove = new HashSet<UUID>();
        HashSet<UUID> outsideFamiliarsCopy = new HashSet<UUID>(this.outsideFamiliars);
        for (UUID familiarId : outsideFamiliarsCopy) {
            Entity entity = serverLevel.getEntity(familiarId);
            if (entity == null) {
                familiarsToRemove.add(familiarId);
                FamiliarsLib.LOGGER.debug("Familiar {} no longer exists in world, removed from tracking", (Object)familiarId);
                continue;
            }
            if (entity instanceof AbstractSpellCastingPet) {
                AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
                if (familiar.isAlive() && !familiar.isRemoved()) continue;
                familiarsToRemove.add(familiarId);
                FamiliarsLib.LOGGER.debug("Familiar {} is dead or removed, cleaning up", (Object)familiarId);
                continue;
            }
            familiarsToRemove.add(familiarId);
            FamiliarsLib.LOGGER.debug("Entity {} is not a familiar, removing from tracking", (Object)familiarId);
        }
        if (!familiarsToRemove.isEmpty()) {
            this.outsideFamiliars.removeAll(familiarsToRemove);
            this.setChanged();
            this.syncToClient();
        }
    }

    protected void handleDistantFamiliars() {
        if (this.outsideFamiliars.isEmpty()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)this.level;
        BlockPos storagePos = this.getBlockPos();
        HashSet<UUID> familiarsToRecall = new HashSet<UUID>();
        HashSet<UUID> outsideFamiliarsCopy = new HashSet<UUID>(this.outsideFamiliars);
        for (UUID familiarId : outsideFamiliarsCopy) {
            Entity entity = serverLevel.getEntity(familiarId);
            if (!(entity instanceof AbstractSpellCastingPet)) continue;
            AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
            double distance = familiar.position().distanceTo(Vec3.atCenterOf((Vec3i)storagePos));
            if (!this.isDaytime()) {
                FamiliarsLib.LOGGER.debug("Night time - forcing recall of familiar {}", (Object)familiarId);
                if (!this.tryRecallFamiliar(familiar)) continue;
                familiarsToRecall.add(familiarId);
                continue;
            }
            if (!(distance > (double)this.maxDistance)) continue;
            FamiliarsLib.LOGGER.debug("Familiar {} too far from house ({}), forcing recall", (Object)familiarId, (Object)distance);
            if (!this.tryRecallFamiliar(familiar)) continue;
            familiarsToRecall.add(familiarId);
        }
        this.outsideFamiliars.removeAll(familiarsToRecall);
    }

    protected abstract Direction getFacingDirection();

    protected Vec3 findSafeReleasePosition() {
        Direction facing;
        BlockPos storagePos = this.getBlockPos();
        BlockPos frontPos = storagePos.relative(facing = this.getFacingDirection());
        if (this.isSafeSpawnPosition(frontPos)) {
            return Vec3.atBottomCenterOf((Vec3i)frontPos);
        }
        return null;
    }

    protected boolean isSafeSpawnPosition(BlockPos pos) {
        return this.level.getBlockState(pos).isAir() && this.level.getBlockState(pos.above()).isAir() && this.level.getBlockState(pos.below()).isSolid();
    }

    private boolean isDaytime() {
        long time = this.level.getDayTime() % 24000L;
        return time >= 1000L && time <= 12000L;
    }

    public boolean tryRecallFamiliar(AbstractSpellCastingPet familiar) {
        if (!this.canStoreFamiliar()) {
            return false;
        }
        UUID familiarId = familiar.getUUID();
        if (this.outsideFamiliars.contains(familiarId) && familiar.getIsInHouse().booleanValue() && this.getBlockPos().equals((Object)familiar.housePosition)) {
            CompoundTag nbtData = FamiliarManager.createFamiliarNBT(familiar);
            FamiliarData familiarData = new FamiliarData(nbtData, 0);
            this.storedFamiliars.put(familiarId, familiarData);
            this.outsideFamiliars.remove(familiarId);
            familiar.remove(Entity.RemovalReason.DISCARDED);
            this.level.playSound(null, this.getBlockPos(), SoundEvents.BEEHIVE_ENTER, SoundSource.BLOCKS, 1.0f, 1.0f);
            this.level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, this.getBlockPos(), GameEvent.Context.of((Entity)familiar, (BlockState)this.getBlockState()));
            this.setChanged();
            this.syncToClient();
            FamiliarsLib.LOGGER.debug("Recalled familiar {} to storage", (Object)familiarId);
            return true;
        }
        return false;
    }

    public void setOwner(ServerPlayer player) {
        this.ownerUUID = player.getUUID();
        this.setChanged();
    }

    public boolean isOwner(ServerPlayer player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.getUUID());
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public Map<UUID, CompoundTag> getStoredFamiliars() {
        HashMap<UUID, CompoundTag> result = new HashMap<UUID, CompoundTag>();
        for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
            result.put(entry.getKey(), entry.getValue().nbtData);
        }
        return result;
    }

    public boolean isFamiliarPhysicallyStored(UUID familiarId) {
        return this.storedFamiliars.containsKey(familiarId);
    }

    public Map<UUID, CompoundTag> getPhysicallyStoredFamiliars() {
        HashMap<UUID, CompoundTag> result = new HashMap<UUID, CompoundTag>();
        for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
            result.put(entry.getKey(), entry.getValue().nbtData);
        }
        return result;
    }

    public boolean canStoreFamiliar() {
        return this.storedFamiliars.size() + this.outsideFamiliars.size() < 10;
    }

    public int getStoredFamiliarCount() {
        return this.storedFamiliars.size();
    }

    public int getMaxStoredFamiliars() {
        return 10;
    }

    public int getOutsideFamiliarCount() {
        return this.outsideFamiliars.size();
    }

    public boolean storeFamiliar(UUID familiarId, CompoundTag familiarData, ServerPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        if (!this.canStoreFamiliar()) {
            return false;
        }
        return FamiliarManager.storeFamiliarInHouse(familiarId, familiarData, player, this.getBlockPos());
    }

    public boolean retrieveFamiliar(UUID familiarId, ServerPlayer player) {
        if (!this.isOwner(player)) {
            return false;
        }
        PlayerFamiliarData playerData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
        if (!playerData.canTameMoreFamiliars()) {
            return false;
        }
        if (this.storedFamiliars.containsKey(familiarId)) {
            return FamiliarManager.retrieveFamiliarFromHouse(familiarId, player, this.getBlockPos());
        }
        return false;
    }

    public void returnFamiliarsToOwner() {
        ServerLevel serverLevel;
        ServerPlayer owner;
        if (this.ownerUUID == null || this.level == null || this.level.isClientSide) {
            return;
        }
        Level level = this.level;
        if (level instanceof ServerLevel && (owner = (serverLevel = (ServerLevel)level).getServer().getPlayerList().getPlayer(this.ownerUUID)) != null) {
            PlayerFamiliarData playerData = (PlayerFamiliarData)owner.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
                UUID familiarId = entry.getKey();
                CompoundTag familiarData = entry.getValue().nbtData;
                if (!playerData.canTameMoreFamiliars()) continue;
                familiarData.putBoolean("isInHouse", false);
                playerData.addTamedFamiliar(familiarId, familiarData);
                if (playerData.getSelectedFamiliarId() == null) {
                    playerData.setSelectedFamiliarId(familiarId);
                }
                FamiliarsLib.LOGGER.debug("Returned familiar {} to owner {}", (Object)familiarId, (Object)owner.getName().getString());
            }
            for (UUID familiarId : this.outsideFamiliars) {
                Entity entity = serverLevel.getEntity(familiarId);
                if (!(entity instanceof AbstractSpellCastingPet)) continue;
                AbstractSpellCastingPet familiar = (AbstractSpellCastingPet)entity;
                familiar.setIsInHouse(false, null);
                familiar.remove(Entity.RemovalReason.DISCARDED);
                FamiliarsLib.LOGGER.debug("Removed outside familiar {} from world due to house destruction", (Object)familiarId);
            }
            FamiliarManager.syncFamiliarDataForPlayer(owner);
        }
        this.storedFamiliars.clear();
        this.outsideFamiliars.clear();
    }

    public void setClientStoreMode(boolean storeMode) {
        if (this.level != null && this.level.isClientSide) {
            this.storeMode = storeMode;
            FamiliarsLib.LOGGER.info("Client updated storage mode to: {}", (Object)(storeMode ? "Store" : "Wander"));
        }
    }

    public void setClientCanFamiliarsUseGoals(boolean canFamiliarsUseGoals) {
        if (this.level != null && this.level.isClientSide) {
            this.canFamiliarsUseGoals = canFamiliarsUseGoals;
            FamiliarsLib.LOGGER.info("Client updated can familiars use goals to: {}", (Object)canFamiliarsUseGoals);
        }
    }

    public void setClientMaxDistance(int maxDistance) {
        if (this.level != null && this.level.isClientSide) {
            this.maxDistance = maxDistance;
            FamiliarsLib.LOGGER.info("Client updated max distance to: {}", (Object)maxDistance);
        }
    }

    public boolean ownsFamiliar(UUID familiarId) {
        return this.storedFamiliars.containsKey(familiarId) || this.outsideFamiliars.contains(familiarId);
    }

    public void handleFamiliarDeath(UUID familiarId) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        boolean wasTracked = false;
        if (this.outsideFamiliars.remove(familiarId)) {
            wasTracked = true;
            FamiliarsLib.LOGGER.debug("Removed dead familiar {} from outside tracking", (Object)familiarId);
        }
        if (this.storedFamiliars.remove(familiarId) != null) {
            wasTracked = true;
            FamiliarsLib.LOGGER.debug("Removed dead familiar {} from stored familiars (unusual case)", (Object)familiarId);
        }
        if (wasTracked) {
            ServerLevel serverLevel;
            ServerPlayer owner;
            Level level;
            this.setChanged();
            this.syncToClient();
            if (this.ownerUUID != null && (level = this.level) instanceof ServerLevel && (owner = (serverLevel = (ServerLevel)level).getServer().getPlayerList().getPlayer(this.ownerUUID)) != null) {
                owner.displayClientMessage((Component)Component.translatable((String)"message.familiarslib.familiar_died_in_house").withStyle(ChatFormatting.RED), false);
            }
        }
    }

    public void syncToClient() {
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (this.ownerUUID != null) {
            tag.putUUID("ownerUUID", this.ownerUUID);
        }
        tag.putInt("ticksSinceLastRelease", this.ticksSinceLastRelease);
        tag.putBoolean("storeMode", this.storeMode);
        tag.putBoolean("wasNightTime", this.wasNightTime);
        tag.putBoolean("canFamiliarsUseGoals", this.canFamiliarsUseGoals);
        tag.putInt("maxDistance", this.maxDistance);
        tag.putInt("dayNightTransitionCooldown", this.dayNightTransitionCooldown);
        ListTag storedList = new ListTag();
        for (Map.Entry<UUID, FamiliarData> entry : this.storedFamiliars.entrySet()) {
            CompoundTag familiarEntry = new CompoundTag();
            familiarEntry.putUUID("id", entry.getKey());
            familiarEntry.put("data", (Tag)entry.getValue().nbtData);
            familiarEntry.putInt("occupationTime", entry.getValue().occupationTime);
            storedList.add((Object)familiarEntry);
        }
        tag.put("storedFamiliars", (Tag)storedList);
        ListTag outsideList = new ListTag();
        for (UUID familiarId : this.outsideFamiliars) {
            CompoundTag outsideEntry = new CompoundTag();
            outsideEntry.putUUID("id", familiarId);
            outsideList.add((Object)outsideEntry);
        }
        tag.put("outsideFamiliars", (Tag)outsideList);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        UUID id;
        int i;
        super.loadAdditional(tag, registries);
        if (tag.hasUUID("ownerUUID")) {
            this.ownerUUID = tag.getUUID("ownerUUID");
        }
        this.ticksSinceLastRelease = tag.getInt("ticksSinceLastRelease");
        this.storeMode = tag.getBoolean("storeMode");
        this.wasNightTime = tag.getBoolean("wasNightTime");
        this.canFamiliarsUseGoals = tag.getBoolean("canFamiliarsUseGoals");
        this.maxDistance = tag.getInt("maxDistance");
        this.dayNightTransitionCooldown = tag.getInt("dayNightTransitionCooldown");
        this.storedFamiliars.clear();
        if (tag.contains("storedFamiliars", 9)) {
            ListTag storedList = tag.getList("storedFamiliars", 10);
            for (i = 0; i < storedList.size(); ++i) {
                CompoundTag familiarEntry = storedList.getCompound(i);
                if (!familiarEntry.hasUUID("id")) continue;
                id = familiarEntry.getUUID("id");
                CompoundTag data = familiarEntry.getCompound("data");
                int occupationTime = familiarEntry.getInt("occupationTime");
                this.storedFamiliars.put(id, new FamiliarData(data, occupationTime));
            }
        }
        this.outsideFamiliars.clear();
        if (tag.contains("outsideFamiliars", 9)) {
            ListTag outsideList = tag.getList("outsideFamiliars", 10);
            for (i = 0; i < outsideList.size(); ++i) {
                CompoundTag outsideEntry = outsideList.getCompound(i);
                if (!outsideEntry.hasUUID("id")) continue;
                id = outsideEntry.getUUID("id");
                this.outsideFamiliars.add(id);
            }
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        this.saveAdditional(tag, registries);
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        super.handleUpdateTag(tag, registries);
        this.loadAdditional(tag, registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static class FamiliarData {
        public final CompoundTag nbtData;
        public int occupationTime;

        public FamiliarData(CompoundTag nbtData, int occupationTime) {
            this.nbtData = nbtData;
            this.occupationTime = occupationTime;
        }

        public boolean canBeReleased() {
            return this.occupationTime >= 100;
        }
    }
}

