/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.block.entity;

import java.util.UUID;
import javax.annotation.Nonnull;
import net.alshanex.familiarslib.data.BedLinkData;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class AbstractFamiliarBedBlockEntity
extends BlockEntity {
    private UUID ownerUUID = null;

    public AbstractFamiliarBedBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
        this.setChanged();
    }

    public boolean isOwner(Player player) {
        return this.ownerUUID != null && this.ownerUUID.equals(player.getUUID());
    }

    public UUID getLinkedFamiliar() {
        if (this.ownerUUID == null || this.level == null) {
            return null;
        }
        Player owner = this.level.getPlayerByUUID(this.ownerUUID);
        if (!(owner instanceof ServerPlayer)) {
            return null;
        }
        ServerPlayer serverPlayer = (ServerPlayer)owner;
        BedLinkData linkData = (BedLinkData)serverPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
        return linkData.getLinkedFamiliar(this.worldPosition);
    }

    public boolean hasLinkedFamiliar() {
        return this.getLinkedFamiliar() != null;
    }

    public boolean isLinkedToPet(UUID petUUID) {
        if (this.ownerUUID == null || this.level == null || petUUID == null) {
            return false;
        }
        Player owner = this.level.getPlayerByUUID(this.ownerUUID);
        if (owner == null) {
            return false;
        }
        BedLinkData linkData = (BedLinkData)owner.getData(AttachmentRegistry.BED_LINK_DATA);
        UUID linkedFamiliar = linkData.getLinkedFamiliar(this.worldPosition);
        return linkedFamiliar != null && linkedFamiliar.equals(petUUID);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        if (pTag.hasUUID("ownerUUID")) {
            this.ownerUUID = pTag.getUUID("ownerUUID");
        }
    }

    protected void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registryAccess) {
        if (this.ownerUUID != null) {
            tag.putUUID("ownerUUID", this.ownerUUID);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        if (this.ownerUUID != null) {
            tag.putUUID("ownerUUID", this.ownerUUID);
        }
        return tag;
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        this.loadAdditional(tag, lookupProvider);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        ClientboundBlockEntityDataPacket packet = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        return packet;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    public Vec3 getSleepPosition() {
        return new Vec3((double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.125, (double)this.worldPosition.getZ() + 0.5);
    }

    public boolean isPositionCorrectForSleeping(Vec3 entityPos) {
        Vec3 sleepPos = this.getSleepPosition();
        double distance = entityPos.distanceTo(sleepPos);
        return distance <= 1.0;
    }

    public void onBedBroken() {
        Player owner;
        if (this.ownerUUID != null && this.level != null && !this.level.isClientSide && (owner = this.level.getPlayerByUUID(this.ownerUUID)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)owner;
            BedLinkData linkData = (BedLinkData)serverPlayer.getData(AttachmentRegistry.BED_LINK_DATA);
            linkData.unlinkBed(this.worldPosition);
        }
    }
}

