/*
 * Decompiled with CFR 0.152.
 */
package net.alshanex.familiarslib.block;

import java.util.Map;
import java.util.UUID;
import net.alshanex.familiarslib.FamiliarsLib;
import net.alshanex.familiarslib.block.entity.AbstractFamiliarBedBlockEntity;
import net.alshanex.familiarslib.data.PlayerFamiliarData;
import net.alshanex.familiarslib.entity.AbstractSpellCastingPet;
import net.alshanex.familiarslib.network.OpenBedLinkSelectionPacket;
import net.alshanex.familiarslib.registry.AttachmentRegistry;
import net.alshanex.familiarslib.util.familiars.FamiliarManager;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFamiliarBedBlock
extends BaseEntityBlock {
    public AbstractFamiliarBedBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (!level.isClientSide && placer instanceof Player) {
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof AbstractFamiliarBedBlockEntity) {
                AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
                petBed.setOwnerUUID(player.getUUID());
            }
        }
    }

    protected void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity blockEntity;
        if (state.getBlock() != newState.getBlock() && (blockEntity = level.getBlockEntity(pos)) instanceof AbstractFamiliarBedBlockEntity) {
            AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
            petBed.onBedBroken();
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (pLevel.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!(blockEntity instanceof AbstractFamiliarBedBlockEntity)) {
            return InteractionResult.FAIL;
        }
        AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
        if (!petBed.isOwner(pPlayer)) {
            if (pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_bed_owner").withStyle(ChatFormatting.RED)));
            }
            return InteractionResult.FAIL;
        }
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            AbstractFamiliarBedBlock.updateSummonedFamiliarsData(serverPlayer);
            PlayerFamiliarData familiarData = (PlayerFamiliarData)serverPlayer.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            if (familiarData.isEmpty()) {
                serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.no_familiars").withStyle(ChatFormatting.RED)));
                return InteractionResult.FAIL;
            }
            FamiliarManager.syncFamiliarDataForPlayer(serverPlayer);
            serverPlayer.level().getServer().execute(() -> PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)new OpenBedLinkSelectionPacket(pPos), (CustomPacketPayload[])new CustomPacketPayload[0]));
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private static void updateSummonedFamiliarsData(ServerPlayer player) {
        try {
            PlayerFamiliarData familiarData = (PlayerFamiliarData)player.getData(AttachmentRegistry.PLAYER_FAMILIAR_DATA);
            ServerLevel level = player.serverLevel();
            int updatedCount = 0;
            for (Map.Entry<UUID, CompoundTag> entry : familiarData.getAllFamiliars().entrySet()) {
                AbstractSpellCastingPet familiar;
                UUID familiarId = entry.getKey();
                Entity entity = level.getEntity(familiarId);
                if (!(entity instanceof AbstractSpellCastingPet) || (familiar = (AbstractSpellCastingPet)entity).getSummoner() == null || !familiar.getSummoner().is((Entity)player)) continue;
                FamiliarManager.updateFamiliarData(familiar);
                ++updatedCount;
                FamiliarsLib.LOGGER.debug("Updated data for summoned familiar {}", (Object)familiarId);
            }
            if (updatedCount > 0) {
                FamiliarsLib.LOGGER.debug("Updated data for {} summoned familiars before opening bed link screen", (Object)updatedCount);
            }
        }
        catch (Exception e) {
            FamiliarsLib.LOGGER.error("Error updating summoned familiars data for bed interaction: ", (Throwable)e);
        }
    }

    protected float getDestroyProgress(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractFamiliarBedBlockEntity) {
            ServerPlayer serverPlayer;
            AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
            if (player instanceof ServerPlayer && !petBed.isOwner((Player)(serverPlayer = (ServerPlayer)player))) {
                if (!player.level().isClientSide()) {
                    serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)Component.translatable((String)"message.familiarslib.not_bed_owner").withStyle(ChatFormatting.RED)));
                }
                return 0.0f;
            }
        }
        return super.getDestroyProgress(state, player, level, pos);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof AbstractFamiliarBedBlockEntity) {
            ServerPlayer serverPlayer;
            AbstractFamiliarBedBlockEntity petBed = (AbstractFamiliarBedBlockEntity)blockEntity;
            if (player instanceof ServerPlayer && !petBed.isOwner((Player)(serverPlayer = (ServerPlayer)player))) {
                return false;
            }
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }
}

