/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.muon.irons_apothic.affix.AffixSchoolMapper;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;

public class SpellLevelAffix
extends Affix {
    public static final Codec<SpellLevelAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(Affix.affixDef(), (App)ResourceLocation.CODEC.fieldOf("school").forGetter(a -> a.school.getId()), (App)LootRarity.mapCodec((Codec)Codec.INT).fieldOf("values").forGetter(a -> a.values), (App)LootCategory.SET_CODEC.fieldOf("types").forGetter(a -> a.validTypes)).apply((Applicative)inst, SpellLevelAffix::new));
    protected final SchoolType school;
    protected final Map<LootRarity, Integer> values;
    protected final Set<LootCategory> validTypes;

    public SpellLevelAffix(AffixDefinition definition, ResourceLocation schoolId, Map<LootRarity, Integer> values, Set<LootCategory> types) {
        super(definition);
        this.school = SchoolRegistry.getSchool((ResourceLocation)schoolId);
        if (this.school == null) {
            throw new IllegalArgumentException("Invalid school ID provided for SpellLevelAffix: " + String.valueOf(schoolId));
        }
        this.values = values;
        this.validTypes = types;
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        Integer bonus = this.values.get(inst.rarity().get());
        if (bonus == null) {
            return Component.empty();
        }
        String schoolTranslationKey = "school." + this.school.getId().getNamespace() + "." + this.school.getId().getPath();
        return Component.translatable((String)"affix.irons_apothic.spell_level.desc", (Object[])new Object[]{Component.translatable((String)schoolTranslationKey), bonus});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        return this.getDescription(inst, ctx);
    }

    public SchoolType getSchool() {
        return this.school;
    }

    public int getBonusLevel(LootRarity rarity, float level) {
        return this.values.getOrDefault(rarity, 0);
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        if (cat.isNone() || !this.values.containsKey(rarity)) {
            return false;
        }
        if (!this.validTypes.isEmpty() && !this.validTypes.contains(cat)) {
            return false;
        }
        Set<SchoolType> gearSchools = AffixSchoolMapper.getSpellSchoolsFromGear(stack);
        return gearSchools.contains(this.school);
    }
}

