/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.irons_apothic.affix;

import dev.muon.irons_apothic.affix.SpellEffectAffix;
import dev.muon.irons_apothic.affix.SpellLevelAffix;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixHelper;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import io.redspace.ironsspellbooks.api.events.SpellDamageEvent;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.events.SpellOnCastEvent;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.SchoolType;
import java.util.Map;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;

public class AffixEventHandler {
    public static void register() {
        NeoForge.EVENT_BUS.register((Object)new AffixEventHandler());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void dropsLowest(LivingDropsEvent e) {
        LivingEntity living;
        Projectile spell;
        DamageSource src = e.getSource();
        Entity directEntity = src.getDirectEntity();
        Entity causingEntity = src.getEntity();
        boolean canTeleport = false;
        Vec3 targetPos = null;
        ItemStack sourceWeapon = ItemStack.EMPTY;
        if (directEntity instanceof Projectile && (spell = (Projectile)directEntity).getOwner() != null && !(sourceWeapon = AffixHelper.getSourceWeapon((Entity)spell)).isEmpty() && (canTeleport = AffixHelper.streamAffixes((ItemStack)sourceWeapon).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = spell.getOwner().position();
        }
        if (!canTeleport && causingEntity instanceof LivingEntity && (canTeleport = AffixHelper.streamAffixes((ItemStack)(sourceWeapon = (living = (LivingEntity)causingEntity).getMainHandItem())).anyMatch(AffixInstance::enablesTelepathy))) {
            targetPos = living.position();
        }
        if (canTeleport && targetPos != null) {
            for (ItemEntity item : e.getDrops()) {
                item.setPos(targetPos.x, targetPos.y, targetPos.z);
                item.setPickUpDelay(0);
            }
        }
    }

    @SubscribeEvent
    public void hookSpellDamageAffix(SpellDamageEvent event) {
        LivingEntity living;
        LivingEntity caster;
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        Entity entity = event.getSpellDamageSource().getEntity();
        LivingEntity livingEntity = caster = entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
        if (caster == null) {
            return;
        }
        for (ItemStack stack : caster.getAllSlots()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Affix patt0$temp = inst.getAffix();
                if (patt0$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)patt0$temp;
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_TARGET) {
                        affix.applyEffectInternal(event.getEntity(), (AffixInstance)inst);
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_DAMAGE_SELF) {
                        affix.applyEffectInternal(caster, (AffixInstance)inst);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void hookSpellHealAffix(SpellHealEvent event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        for (ItemStack stack : event.getEntity().getAllSlots()) {
            AffixHelper.streamAffixes((ItemStack)stack).forEach(inst -> {
                Affix patt0$temp = inst.getAffix();
                if (patt0$temp instanceof SpellEffectAffix) {
                    SpellEffectAffix affix = (SpellEffectAffix)patt0$temp;
                    if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_TARGET) {
                        affix.applyEffectInternal(event.getTargetEntity(), (AffixInstance)inst);
                    } else if (affix.target == SpellEffectAffix.SpellTarget.SPELL_HEAL_SELF) {
                        affix.applyEffectInternal(event.getEntity(), (AffixInstance)inst);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public void onSpellCast(SpellOnCastEvent event) {
        Player player = event.getEntity();
        SchoolType school = event.getSchoolType();
        CastSource source = event.getCastSource();
        ItemStack castingStack = ItemStack.EMPTY;
        if (source == CastSource.SPELLBOOK || source == CastSource.SWORD) {
            castingStack = player.getMainHandItem();
        }
        if (castingStack.isEmpty()) {
            return;
        }
        int totalBonus = 0;
        Map affixes = AffixHelper.getAffixes((ItemStack)castingStack);
        for (AffixInstance instance : affixes.values()) {
            SpellLevelAffix spellLevelAffix;
            Affix affix;
            if (!instance.isValid() || !instance.affix().isBound() || !((affix = instance.getAffix()) instanceof SpellLevelAffix) || (spellLevelAffix = (SpellLevelAffix)affix).getSchool() != school) continue;
            int bonus = spellLevelAffix.getBonusLevel(instance.getRarity(), instance.level());
            totalBonus += bonus;
        }
        if (totalBonus > 0) {
            event.setSpellLevel(event.getOriginalSpellLevel() + totalBonus);
        }
    }
}

