/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.logic;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import net.bettercombat.BetterCombatMod;
import net.bettercombat.config.ServerConfig;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class TargetHelper {
    private static Map<TagKey<EntityType<?>>, Relation> RELATION_TAG_CACHE = null;
    private static final Map<String, TeamMatcher> TEAM_MATCHERS = new LinkedHashMap<String, TeamMatcher>();

    public static Relation getRelation(Player attacker, Entity target) {
        Object tameable;
        LivingEntity owner;
        ServerConfig config = BetterCombatMod.config;
        if (attacker == target) {
            return config.player_relation_to_self_and_pets;
        }
        if (target instanceof OwnableEntity && (owner = (tameable = (OwnableEntity)target).getOwner()) != null) {
            return TargetHelper.getRelation(attacker, (Entity)owner);
        }
        if (target instanceof HangingEntity) {
            return Relation.NEUTRAL;
        }
        for (TeamMatcher matcher : TEAM_MATCHERS.values()) {
            TeamRelation relation = matcher.getRelation((Entity)attacker, target);
            if (relation == null) continue;
            return relation.areTeammates() ? (relation.friendlyFireAllowed() ? config.player_relation_to_teammates : Relation.FRIENDLY) : Relation.HOSTILE;
        }
        Holder targetTypeEntry = BuiltInRegistries.ENTITY_TYPE.wrapAsHolder((Object)target.getType());
        ResourceLocation id = ((ResourceKey)targetTypeEntry.unwrapKey().get()).location();
        Relation mappedRelation = config.player_relations.get(id.toString());
        if (mappedRelation != null) {
            return mappedRelation;
        }
        for (Map.Entry<TagKey<EntityType<?>>, Relation> entry : TargetHelper.getRelationTagsCache().entrySet()) {
            if (!targetTypeEntry.is(entry.getKey())) continue;
            return entry.getValue();
        }
        if (target instanceof AgeableMob) {
            return Relation.coalesce(config.player_relation_to_passives, Relation.HOSTILE);
        }
        if (target instanceof Monster) {
            return Relation.coalesce(config.player_relation_to_hostiles, Relation.HOSTILE);
        }
        return Relation.coalesce(config.player_relation_to_other, Relation.HOSTILE);
    }

    private static Map<TagKey<EntityType<?>>, Relation> getRelationTagsCache() {
        if (RELATION_TAG_CACHE == null) {
            RELATION_TAG_CACHE = new HashMap();
            for (Map.Entry<String, Relation> entrySet : BetterCombatMod.config.player_relation_tags.entrySet()) {
                String tagString = entrySet.getKey();
                Relation relation = entrySet.getValue();
                TagKey tag = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.parse((String)tagString));
                RELATION_TAG_CACHE.put(tag, relation);
            }
        }
        return RELATION_TAG_CACHE;
    }

    public static void registerTeamMatcher(String name, TeamMatcher matcher) {
        TEAM_MATCHERS.put(name, matcher);
    }

    public static boolean isAttackableMount(Entity entity) {
        if (entity instanceof Monster || TargetHelper.isEntityHostileVehicle(entity.getName().getString())) {
            return true;
        }
        return BetterCombatMod.config.allow_attacking_mount;
    }

    public static boolean isEntityHostileVehicle(String entityName) {
        ServerConfig config = BetterCombatMod.config;
        return config.hostile_player_vehicles != null && config.hostile_player_vehicles.length > 0 && Arrays.asList(config.hostile_player_vehicles).contains(entityName);
    }

    public static boolean isHitAllowed(boolean isDirect, Relation relation) {
        if (isDirect) {
            return relation != Relation.FRIENDLY;
        }
        return relation == Relation.HOSTILE;
    }

    static {
        TargetHelper.registerTeamMatcher("vanilla", (entity1, entity2) -> {
            PlayerTeam team1 = entity1.getTeam();
            PlayerTeam team2 = entity2.getTeam();
            if (team1 == null || team2 == null) {
                return null;
            }
            boolean friendlyFire = team1.isAllowFriendlyFire();
            return new TeamRelation(entity1.isAlliedTo(entity2), friendlyFire);
        });
    }

    public static enum Relation {
        FRIENDLY,
        NEUTRAL,
        HOSTILE;


        public static Relation coalesce(Relation value, Relation fallback) {
            if (value != null) {
                return value;
            }
            return fallback;
        }
    }

    public static interface TeamMatcher {
        @Nullable
        public TeamRelation getRelation(Entity var1, Entity var2);
    }

    public record TeamRelation(boolean areTeammates, boolean friendlyFireAllowed) {
    }
}

