/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.web.local.client;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import dev.latvian.apps.tinyserver.content.ResponseContent;
import dev.latvian.apps.tinyserver.http.response.HTTPResponse;
import dev.latvian.apps.tinyserver.http.response.HTTPStatus;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.bindings.UUIDWrapper;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.util.CachedComponentObject;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.Lazy;
import dev.latvian.mods.kubejs.web.JsonContent;
import dev.latvian.mods.kubejs.web.KJSHTTPRequest;
import dev.latvian.mods.kubejs.web.LocalWebServer;
import dev.latvian.mods.kubejs.web.LocalWebServerRegistry;
import dev.latvian.mods.kubejs.web.local.KubeJSWeb;
import dev.latvian.mods.kubejs.web.local.client.ImageGenerator;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class KubeJSClientWeb {
    public static final Lazy<Map<UUID, CachedComponentObject<Item, ItemStack>>> CACHED_ITEM_SEARCH = Lazy.of(() -> {
        LinkedHashMap<UUID, CachedComponentObject<Item, ItemStack>> map = new LinkedHashMap<UUID, CachedComponentObject<Item, ItemStack>>();
        for (ItemStack stack : ((CreativeModeTab)BuiltInRegistries.CREATIVE_MODE_TAB.get(CreativeModeTabs.SEARCH)).getSearchTabDisplayItems()) {
            DataComponentPatch patch = stack.getComponentsPatch();
            map.put(UUID.randomUUID(), new CachedComponentObject<Item, ItemStack>(UUID.randomUUID(), stack.getItem(), stack, patch));
        }
        return map;
    });
    public static final Lazy<Map<CachedComponentObject, UUID>> REVERSE_CACHED_ITEM_SEARCH = Lazy.of(() -> {
        HashMap map = new HashMap();
        CACHED_ITEM_SEARCH.get().forEach((uuid, obj) -> map.put(obj, uuid));
        return map;
    });

    public static void register(LocalWebServerRegistry registry) {
        KubeJSWeb.addScriptTypeEndpoints(registry, ScriptType.CLIENT, KubeJS.getClientScriptManager()::reload);
        registry.get("/api/client/translate/{key}", KubeJSClientWeb::getTranslate);
        registry.get("/api/client/component-string/{json}", KubeJSClientWeb::getComponentString);
        registry.get("/api/client/search/items", KubeJSClientWeb::getSearchItems);
        registry.get("/api/client/search/blocks", KubeJSClientWeb::getSearchBlocks);
        registry.get("/api/client/search/fluids", KubeJSClientWeb::getSearchFluids);
        registry.get("/api/client/assets/list/<prefix>", KubeJSClientWeb::getAssetList);
        registry.get("/api/client/assets/get/{namespace}/<path>", KubeJSClientWeb::getAssetContent);
        registry.get("/img/screenshot", KubeJSClientWeb::getScreenshot);
        registry.get("/img/{size}/item/{namespace}/{path}", ImageGenerator::item);
        registry.get("/img/{size}/block/{namespace}/{path}", ImageGenerator::block);
        registry.get("/img/{size}/fluid/{namespace}/{path}", ImageGenerator::fluid);
        registry.get("/img/{size}/item-tag/{namespace}/{path}", ImageGenerator::itemTag);
        registry.get("/img/{size}/block-tag/{namespace}/{path}", ImageGenerator::blockTag);
        registry.get("/img/{size}/fluid-tag/{namespace}/{path}", ImageGenerator::fluidTag);
    }

    private static HTTPResponse getScreenshot(KJSHTTPRequest req) {
        byte[] bytes = req.supplyInMainThread(() -> {
            Minecraft mc = Minecraft.getInstance();
            mc.getMainRenderTarget().bindRead();
            try {
                byte[] byArray;
                NativeImage image = new NativeImage(mc.getWindow().getWidth(), mc.getWindow().getHeight(), false);
                try {
                    image.downloadTexture(0, true);
                    image.flipY();
                    byArray = image.asByteArray();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        byte[] byArray2 = null;
                        return byArray2;
                    }
                }
                image.close();
                return byArray;
            }
            finally {
                mc.getMainRenderTarget().unbindRead();
            }
        });
        return HTTPResponse.ok().content(bytes, "image/png");
    }

    private static HTTPResponse getTranslate(KJSHTTPRequest req) {
        return HTTPResponse.ok().text(I18n.get((String)req.variable("key"), (Object[])new Object[0]));
    }

    private static HTTPResponse getComponentString(KJSHTTPRequest req) {
        return HTTPResponse.ok().text(((Component)((Pair)ComponentSerialization.FLAT_CODEC.decode(req.registries().java(), (Object)req.variable("json")).getOrThrow()).getFirst()).getString());
    }

    private static HTTPResponse getSearchItems(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.object(json -> {
            RegistryOps jsonOps = Minecraft.getInstance().level == null ? req.registries().json() : Minecraft.getInstance().level.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            RegistryOps nbtOps = Minecraft.getInstance().level == null ? req.registries().nbt() : Minecraft.getInstance().level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
            JsonArray results = new JsonArray();
            String iconPathRoot = LocalWebServer.instance().url() + "/img/64/item/";
            for (CachedComponentObject<Item, ItemStack> item : CACHED_ITEM_SEARCH.get().values()) {
                JsonObject o = new JsonObject();
                o.addProperty("cache_key", UUIDWrapper.toString(item.cacheKey()));
                o.addProperty("id", item.value().kjs$getId());
                o.addProperty("name", item.stack().getHoverName().getString());
                o.addProperty("icon_path", item.stack().kjs$getWebIconURL((DynamicOps)nbtOps, 64).fullString().substring(iconPathRoot.length()));
                DataComponentPatch patch = item.components();
                if (!patch.isEmpty()) {
                    JsonObject p = new JsonObject();
                    try {
                        for (Map.Entry entry : patch.entrySet()) {
                            String key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey())).toString();
                            if (((Optional)entry.getValue()).isEmpty()) {
                                p.add(key, (JsonElement)JsonNull.INSTANCE);
                                continue;
                            }
                            if (((DataComponentType)entry.getKey()).codec() == null) continue;
                            p.add(key, (JsonElement)((DataComponentType)entry.getKey()).codec().encodeStart((DynamicOps)jsonOps, Cast.to(((Optional)entry.getValue()).get())).getOrThrow());
                        }
                        o.add("components", (JsonElement)p);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                JsonArray tags = new JsonArray();
                for (TagKey t : item.value().builtInRegistryHolder().tags().toList()) {
                    tags.add(t.location().toString());
                }
                if (!tags.isEmpty()) {
                    o.add("tags", (JsonElement)tags);
                }
                results.add((JsonElement)o);
            }
            json.addProperty("icon_path_root", iconPathRoot);
            json.add("results", (JsonElement)results);
        }));
    }

    private static HTTPResponse getSearchBlocks(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (Block block : BuiltInRegistries.BLOCK) {
                JsonObject o = new JsonObject();
                o.addProperty("id", block.kjs$getId());
                o.addProperty("name", Component.translatable((String)block.getDescriptionId()).getString());
                JsonArray tags = new JsonArray();
                for (TagKey t : block.builtInRegistryHolder().tags().toList()) {
                    tags.add(t.location().toString());
                }
                if (!tags.isEmpty()) {
                    o.add("tags", (JsonElement)tags);
                }
                json.add((JsonElement)o);
            }
        }));
    }

    private static HTTPResponse getSearchFluids(KJSHTTPRequest req) {
        return HTTPResponse.ok().content((ResponseContent)JsonContent.array(json -> {
            for (Fluid fluid : BuiltInRegistries.FLUID) {
                JsonObject o = new JsonObject();
                o.addProperty("id", fluid.kjs$getId());
                o.addProperty("name", fluid.getFluidType().getDescription().getString());
                JsonArray tags = new JsonArray();
                for (TagKey t : fluid.builtInRegistryHolder().tags().toList()) {
                    tags.add(t.location().toString());
                }
                if (!tags.isEmpty()) {
                    o.add("tags", (JsonElement)tags);
                }
                json.add((JsonElement)o);
            }
        }));
    }

    private static HTTPResponse getAssetList(KJSHTTPRequest req) {
        String prefix = req.variable("prefix");
        if (prefix.isEmpty()) {
            return HTTPStatus.BAD_REQUEST;
        }
        return HTTPResponse.ok().content((ResponseContent)JsonContent.object(json -> {
            for (ResourceLocation id2 : Minecraft.getInstance().getResourceManager().listResources(prefix, id -> true).keySet()) {
                JsonArray arr = (JsonArray)json.get(id2.getNamespace());
                if (arr == null) {
                    arr = new JsonArray();
                    json.add(id2.getNamespace(), (JsonElement)arr);
                }
                arr.add(id2.getPath().substring(prefix.length() + 1));
            }
        }));
    }

    private static HTTPResponse getAssetContent(KJSHTTPRequest req) throws Exception {
        ResourceLocation id = req.id();
        Optional asset = Minecraft.getInstance().getResourceManager().getResource(id);
        if (asset.isEmpty()) {
            return HTTPStatus.NOT_FOUND;
        }
        try (InputStream in = ((Resource)asset.get()).open();){
            if (id.getPath().endsWith(".png")) {
                HTTPResponse hTTPResponse = HTTPResponse.ok().content(in.readAllBytes(), "image/png");
                return hTTPResponse;
            }
            if (id.getPath().endsWith(".json") || id.getPath().endsWith(".mcmeta")) {
                HTTPResponse hTTPResponse = HTTPResponse.ok().content(in.readAllBytes(), "application/json; charset=utf-8");
                return hTTPResponse;
            }
            if (id.getPath().endsWith(".ogg")) {
                HTTPResponse hTTPResponse = HTTPResponse.ok().content(in.readAllBytes(), "audio/ogg");
                return hTTPResponse;
            }
            HTTPResponse hTTPResponse = HTTPResponse.ok().content(in.readAllBytes(), "text/plain");
            return hTTPResponse;
        }
    }
}

