/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util.registrypredicate;

import com.google.gson.JsonPrimitive;
import dev.latvian.mods.kubejs.registry.RegistryType;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.RegExpKJS;
import dev.latvian.mods.kubejs.util.registrypredicate.EntireRegistryPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryHolderPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryIDPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryNamespacePredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryRegExpPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryTagIDPredicate;
import dev.latvian.mods.kubejs.util.registrypredicate.RegistryTagKeyPredicate;
import dev.latvian.mods.rhino.BaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.regexp.NativeRegExp;
import dev.latvian.mods.rhino.type.TypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

@FunctionalInterface
public interface RegistryPredicate<T>
extends Predicate<Holder<T>> {
    public static RegistryPredicate<?> of(Context cx, Object from, TypeInfo target) {
        if (from == null) {
            return EntireRegistryPredicate.FALSE;
        }
        if (from instanceof RegistryPredicate) {
            RegistryPredicate p = (RegistryPredicate)from;
            return p;
        }
        if (from instanceof Pattern || from instanceof NativeRegExp) {
            return new RegistryRegExpPredicate(RegExpKJS.wrap(from));
        }
        if (from instanceof CharSequence || from instanceof JsonPrimitive) {
            Optional opt;
            Registry registry;
            String s;
            if (from instanceof JsonPrimitive) {
                JsonPrimitive p = (JsonPrimitive)from;
                v0 = p.getAsString();
            } else {
                v0 = s = from.toString();
            }
            if (s.equals("*")) {
                return EntireRegistryPredicate.TRUE;
            }
            if (s.equals("-")) {
                return EntireRegistryPredicate.FALSE;
            }
            if (s.startsWith("#")) {
                RegistryType<?> reg = RegistryType.ofType(target.param(0));
                ResourceLocation tag = ID.mc(s.substring(1));
                if (reg != null) {
                    return new RegistryTagKeyPredicate(TagKey.create(reg.key(), (ResourceLocation)tag));
                }
                return new RegistryTagIDPredicate(tag);
            }
            if (s.startsWith("@")) {
                return new RegistryNamespacePredicate(s.substring(1));
            }
            Pattern pattern = RegExpKJS.wrap(s);
            if (pattern != null) {
                return new RegistryRegExpPredicate(pattern);
            }
            RegistryType<?> reg = RegistryType.ofType(target.param(0));
            ResourceLocation id = ID.mc(s);
            if (reg != null && (registry = (Registry)BuiltInRegistries.REGISTRY.get(reg.key())) != null && (opt = registry.getHolder(id)).isPresent()) {
                return new RegistryHolderPredicate((Holder)opt.get());
            }
            return new RegistryIDPredicate(id);
        }
        if (from instanceof BaseFunction) {
            TypeInfo t = target.param(0);
            Predicate predicate = (Predicate)cx.jsToJava(from, t.shouldConvert() ? TypeInfo.RAW_PREDICATE.withParams(new TypeInfo[]{t}) : TypeInfo.RAW_PREDICATE);
            return predicate::test;
        }
        return new RegistryHolderPredicate(new Holder.Direct(from));
    }

    default public List<Holder.Reference<T>> getHolders(Registry<T> registry) {
        return registry.holders().filter(this).toList();
    }

    default public List<T> getValues(Registry<T> registry) {
        return registry.holders().filter(this).map(Holder::value).toList();
    }
}

