/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JavaOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import dev.latvian.mods.kubejs.bindings.RegistryWrapper;
import dev.latvian.mods.kubejs.recipe.CachedItemTagLookup;
import dev.latvian.mods.kubejs.recipe.CachedTagLookup;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.server.DataExport;
import dev.latvian.mods.kubejs.util.Cast;
import dev.latvian.mods.kubejs.util.ID;
import dev.latvian.mods.kubejs.util.MapJS;
import dev.latvian.mods.rhino.Context;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagLoader;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.conditions.ICondition;
import org.jetbrains.annotations.ApiStatus;

public final class RegistryAccessContainer
implements ICondition.IContext {
    public static final RegistryAccessContainer BUILTIN;
    @ApiStatus.Internal
    public static RegistryAccessContainer current;
    private final RegistryAccess.Frozen access;
    private final RegistryOps<Tag> nbt;
    private final RegistryOps<JsonElement> json;
    private final RegistryOps<Object> java;
    private DamageSources damageSources;
    private final Map<String, ItemStack> itemStackParseCache;
    public final Map<ResourceKey<?>, CachedTagLookup.Entry<?>> cachedRegistryTags;
    public CachedItemTagLookup cachedItemTags;
    public CachedTagLookup<Block> cachedBlockTags;
    public CachedTagLookup<Fluid> cachedFluidTags;
    private Map<ResourceLocation, RegistryWrapper> cachedRegistryWrappers;

    public static RegistryAccessContainer of(Context cx) {
        RegistryAccessContainer registryAccessContainer;
        if (cx instanceof KubeJSContext) {
            KubeJSContext kcx = (KubeJSContext)cx;
            registryAccessContainer = kcx.getRegistries();
        } else {
            registryAccessContainer = current;
        }
        return registryAccessContainer;
    }

    public RegistryAccessContainer(RegistryAccess.Frozen access) {
        this.access = access;
        this.nbt = access.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        this.json = access.createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        this.java = access.createSerializationContext((DynamicOps)JavaOps.INSTANCE);
        this.damageSources = null;
        this.itemStackParseCache = new HashMap<String, ItemStack>();
        this.cachedRegistryTags = new Reference2ObjectOpenHashMap();
    }

    public RegistryAccess.Frozen access() {
        return this.access;
    }

    public RegistryOps<Tag> nbt() {
        return this.nbt;
    }

    public RegistryOps<JsonElement> json() {
        return this.json;
    }

    public RegistryOps<Object> java() {
        return this.java;
    }

    public DamageSources damageSources() {
        if (this.damageSources == null) {
            this.damageSources = new DamageSources((RegistryAccess)this.access);
        }
        return this.damageSources;
    }

    public Map<String, ItemStack> itemStackParseCache() {
        return this.itemStackParseCache;
    }

    public synchronized <T> void cacheTags(Registry<T> registry, Map<ResourceLocation, List<TagLoader.EntryWithSource>> map) {
        ResourceKey key1;
        ResourceKey resourceKey = key1 = registry == null ? null : registry.key();
        if (key1 == null) {
            return;
        }
        try {
            if (key1 == Registries.ITEM) {
                this.cachedItemTags = (CachedItemTagLookup)Cast.to(new CachedItemTagLookup((Registry<Item>)registry, map));
                this.cachedRegistryTags.put(key1, new CachedTagLookup.Entry<Item>(key1, registry, this.cachedItemTags));
            } else if (key1 == Registries.BLOCK) {
                this.cachedBlockTags = (CachedTagLookup)Cast.to(new CachedTagLookup<T>(registry, map));
                this.cachedRegistryTags.put(key1, new CachedTagLookup.Entry<Block>(key1, registry, this.cachedBlockTags));
            } else if (key1 == Registries.FLUID) {
                this.cachedFluidTags = (CachedTagLookup)Cast.to(new CachedTagLookup<T>(registry, map));
                this.cachedRegistryTags.put(key1, new CachedTagLookup.Entry<Fluid>(key1, registry, this.cachedFluidTags));
            } else {
                this.cachedRegistryTags.put(key1, new CachedTagLookup.Entry<T>(key1, registry, new CachedTagLookup<T>(registry, map)));
            }
        }
        catch (Exception ex) {
            ConsoleJS.SERVER.error("Error caching tags for " + String.valueOf(key1), ex);
        }
        if (DataExport.export != null) {
            String loc = "tags/" + String.valueOf(key1.location()) + "/";
            for (Map.Entry<ResourceLocation, List<TagLoader.EntryWithSource>> entry : map.entrySet()) {
                ArrayList<String> list = new ArrayList<String>();
                for (TagLoader.EntryWithSource e : entry.getValue()) {
                    list.add(e.entry().toString());
                }
                list.sort(String.CASE_INSENSITIVE_ORDER);
                JsonArray arr = new JsonArray();
                for (String e : list) {
                    arr.add(e);
                }
                DataExport.export.addJson(loc + String.valueOf(entry.getKey()) + ".json", (JsonElement)arr);
            }
        }
    }

    public <T> T decodeJson(Codec<T> codec, JsonElement from) {
        return (T)((Pair)codec.decode(this.json, (Object)from).result().orElseThrow()).getFirst();
    }

    public <T> T decodeNbt(Codec<T> codec, Tag from) {
        return (T)((Pair)codec.decode(this.nbt, (Object)from).result().orElseThrow()).getFirst();
    }

    public <T> T decodeJson(MapCodec<T> mapCodec, JsonElement from) {
        return (T)mapCodec.decode(this.json, (MapLike)this.json.getMap((Object)from).getOrThrow()).getOrThrow();
    }

    public <T> T decode(Context cx, Codec<T> codec, Object o) {
        if (o instanceof Tag) {
            Tag tag = (Tag)o;
            return (T)((Pair)codec.decode(this.nbt, (Object)tag).result().orElseThrow()).getFirst();
        }
        if (o instanceof Map) {
            return (T)((Pair)codec.decode(this.java, o).result().orElseThrow()).getFirst();
        }
        return (T)((Pair)codec.decode(this.json, (Object)MapJS.json(cx, o)).result().orElseThrow()).getFirst();
    }

    public <T> T decodeMap(Context cx, MapCodec<T> codec, Object o) {
        if (o instanceof Tag) {
            Tag tag = (Tag)o;
            return codec.decode(this.nbt, (MapLike)this.nbt.getMap((Object)tag).getOrThrow()).result().orElseThrow();
        }
        if (o instanceof Map) {
            Map map = (Map)o;
            return codec.decode(this.java, (MapLike)this.java.getMap((Object)map).getOrThrow()).result().orElseThrow();
        }
        return codec.decode(this.json, (MapLike)this.json.getMap((Object)MapJS.json(cx, o)).getOrThrow()).result().orElseThrow();
    }

    private <T> RegistryWrapper<T> createRegistryWrapper(ResourceLocation id) {
        ResourceKey key = ResourceKey.createRegistryKey((ResourceLocation)id);
        return new RegistryWrapper(this.access.registryOrThrow(key), ResourceKey.create((ResourceKey)key, (ResourceLocation)ID.UNKNOWN));
    }

    public RegistryWrapper wrapRegistry(ResourceLocation id) {
        if (this.cachedRegistryWrappers == null) {
            this.cachedRegistryWrappers = new HashMap<ResourceLocation, RegistryWrapper>();
        }
        return this.cachedRegistryWrappers.computeIfAbsent(id, this::createRegistryWrapper);
    }

    public <T> Map<ResourceLocation, Collection<Holder<T>>> getAllTags(ResourceKey<? extends Registry<T>> key) {
        CachedTagLookup.Entry<?> cached = this.cachedRegistryTags.get(key);
        if (cached != null) {
            return cached.lookup().tagMap();
        }
        return Map.of();
    }

    static {
        current = BUILTIN = new RegistryAccessContainer(RegistryAccess.fromRegistryOfRegistries((Registry)BuiltInRegistries.REGISTRY));
    }
}

