/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.script;

import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;

public class KubeJSFileWatcherThread
extends Thread {
    public final ScriptType scriptType;
    public final ScriptFile[] files;
    public final Runnable reload;

    public KubeJSFileWatcherThread(ScriptType scriptType, ScriptFile[] files, Runnable reload) {
        super("KubeJS File Watcher");
        this.setDaemon(true);
        this.scriptType = scriptType;
        this.files = files;
        this.reload = reload;
    }

    @Override
    public void run() {
        this.scriptType.console.info("#%08X Started watching %d files".formatted(this.hashCode(), this.files.length));
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        while (this.scriptType.fileWatcherThread == this) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            boolean changed = false;
            for (ScriptFile file : this.files) {
                try {
                    long ms = Files.getLastModifiedTime(file.info.path, new LinkOption[0]).toMillis();
                    if (file.lastModified == ms) continue;
                    file.lastModified = ms;
                    changed = true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (!changed) continue;
            this.scriptType.console.info("#%08X File change detected, reloading scripts...".formatted(this.hashCode()));
            this.reload.run();
            return;
        }
    }
}

