/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.recipe.component;

import com.mojang.serialization.Codec;
import dev.latvian.mods.kubejs.fluid.FluidWrapper;
import dev.latvian.mods.kubejs.recipe.KubeRecipe;
import dev.latvian.mods.kubejs.recipe.component.RecipeComponent;
import dev.latvian.mods.kubejs.recipe.component.UniqueIdBuilder;
import dev.latvian.mods.kubejs.recipe.match.FluidMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatch;
import dev.latvian.mods.kubejs.recipe.match.ReplacementMatchInfo;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.type.TypeInfo;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.crafting.FluidIngredient;
import net.neoforged.neoforge.fluids.crafting.SizedFluidIngredient;

public class SizedFluidIngredientComponent
implements RecipeComponent<SizedFluidIngredient> {
    public static final SizedFluidIngredientComponent FLAT = new SizedFluidIngredientComponent("flat_sized_fluid_ingredient", (Codec<SizedFluidIngredient>)SizedFluidIngredient.FLAT_CODEC);
    public static final SizedFluidIngredientComponent NESTED = new SizedFluidIngredientComponent("nested_sized_fluid_ingredient", (Codec<SizedFluidIngredient>)SizedFluidIngredient.NESTED_CODEC);
    public final String name;
    public final Codec<SizedFluidIngredient> codec;

    public SizedFluidIngredientComponent(String name, Codec<SizedFluidIngredient> codec) {
        this.name = name;
        this.codec = codec;
    }

    @Override
    public Codec<SizedFluidIngredient> codec() {
        return this.codec;
    }

    @Override
    public TypeInfo typeInfo() {
        return FluidWrapper.SIZED_INGREDIENT_TYPE_INFO;
    }

    @Override
    public boolean hasPriority(Context cx, KubeRecipe recipe, Object from) {
        return from instanceof SizedFluidIngredient || from instanceof FluidIngredient || from instanceof FluidStack || from instanceof Fluid;
    }

    @Override
    public boolean matches(Context cx, KubeRecipe recipe, SizedFluidIngredient value, ReplacementMatchInfo match) {
        FluidMatch m;
        ReplacementMatch replacementMatch = match.match();
        return replacementMatch instanceof FluidMatch && (m = (FluidMatch)replacementMatch).matches(cx, value.ingredient(), match.exact());
    }

    @Override
    public boolean isEmpty(SizedFluidIngredient value) {
        return value.amount() <= 0 || value.ingredient().isEmpty();
    }

    @Override
    public void buildUniqueId(UniqueIdBuilder builder, SizedFluidIngredient value) {
        FluidStack[] stacks;
        if (!value.ingredient().isEmpty() && (stacks = value.ingredient().getStacks()).length > 0) {
            builder.append(stacks[0].getFluid().kjs$getIdLocation());
        }
    }

    public String toString() {
        return this.name;
    }
}

