/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.event;

import dev.latvian.mods.kubejs.DevProperties;
import dev.latvian.mods.kubejs.event.EventExit;
import dev.latvian.mods.kubejs.event.EventHandler;
import dev.latvian.mods.kubejs.event.EventResult;
import dev.latvian.mods.kubejs.event.IEventHandler;
import dev.latvian.mods.kubejs.event.KubeEvent;
import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.rhino.WrappedException;
import org.jetbrains.annotations.Nullable;

public class EventHandlerContainer {
    public final Object target;
    public final IEventHandler handler;
    public final String source;
    public final int line;
    EventHandlerContainer child;

    public static boolean isEmpty(@Nullable EventHandlerContainer[] array) {
        if (array == null) {
            return true;
        }
        for (EventHandlerContainer c : array) {
            if (c == null) continue;
            return false;
        }
        return true;
    }

    public EventHandlerContainer(Object target, IEventHandler handler, String source, int line) {
        this.target = target;
        this.handler = handler;
        this.source = source;
        this.line = line;
    }

    public EventResult handle(ConsoleJS console, EventHandler handler, KubeEvent event) throws EventExit {
        EventHandlerContainer itr = this;
        do {
            try {
                itr.handler.onEvent(event);
            }
            catch (EventExit exit) {
                if (handler.getResult() == null) {
                    console.error("Error in '" + String.valueOf(this) + "': Event returned result when it's not cancellable");
                    continue;
                }
                throw exit;
            }
            catch (Throwable ex) {
                Throwable throwable = ex;
                while (throwable instanceof WrappedException) {
                    WrappedException e = (WrappedException)throwable;
                    throwable = e.getWrappedException();
                }
                if (throwable instanceof EventExit) {
                    EventExit exit = (EventExit)throwable;
                    if (handler.getResult() == null) {
                        console.error("Error in '" + String.valueOf(this) + "': Event returned result when it's not cancellable");
                    } else {
                        throw exit;
                    }
                }
                if (handler.exceptionHandler != null && (throwable = handler.exceptionHandler.handle(event, itr, throwable)) == null) continue;
                console.error("Error in '" + String.valueOf((Object)handler) + "'", throwable);
                if (!DevProperties.get().logEventErrorStackTrace) continue;
                throwable.printStackTrace();
            }
        } while ((itr = itr.child) != null);
        return EventResult.PASS;
    }

    public void add(Object extraId, IEventHandler handler, String source, int line) {
        EventHandlerContainer itr = this;
        while (itr.child != null) {
            itr = itr.child;
        }
        itr.child = new EventHandlerContainer(extraId, handler, source, line);
    }

    public String toString() {
        return "Event Handler (" + this.source + ":" + this.line + ")";
    }
}

