/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.script.ConsoleJS;
import dev.latvian.mods.kubejs.script.KubeJSContext;
import dev.latvian.mods.kubejs.typings.Info;
import org.jetbrains.annotations.Nullable;
import org.slf4j.LoggerFactory;

@Info(value="Methods for working with Java classes. Reflection my beloved \u2665")
public interface JavaWrapper {
    @Info(value="Loads the specified class, and throws error if class it not found or allowed.\nThe returned object can have public static methods and fields accessed directly from it.\nConstructors can be used with the new keyword.\n")
    public static Object loadClass(KubeJSContext cx, String className) {
        return cx.loadJavaClass(className, true);
    }

    @Info(value="Loads the specified class, and returns null if class is not found or allowed.\nThe returned object can have public static methods and fields accessed directly from it.\nConstructors can be used with the new keyword.\n")
    @Nullable
    public static Object tryLoadClass(KubeJSContext cx, String className) {
        return cx.loadJavaClass(className, false);
    }

    @Info(value="Creates a custom ConsoleJS instance for you to use to, well, log stuff")
    public static ConsoleJS createConsole(KubeJSContext cx, String name) {
        return new ConsoleJS(cx.getType(), LoggerFactory.getLogger((String)name));
    }
}

