/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.util;

import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;

public class MuscleUtils {
    public static double getDripstoneHeight(double pRadius, double pMaxRadius, double pScale, double pMinRadius) {
        if (pRadius < pMinRadius) {
            pRadius = pMinRadius;
        }
        double d0 = 0.384;
        double d1 = pRadius / pMaxRadius * 0.384;
        double d2 = 0.75 * Math.pow(d1, 1.3333333333333333);
        double d3 = Math.pow(d1, 0.6666666666666666);
        double d4 = 0.3333333333333333 * Math.log(d1);
        double d5 = pScale * (d2 - d3 - d4);
        d5 = Math.max(d5, 0.0);
        return d5 / 0.384 * pMaxRadius;
    }

    public static boolean isCircleMostlyEmbeddedInStone(WorldGenLevel pLevel, BlockPos pPos, int pRadius) {
        if (MuscleUtils.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos)) {
            return false;
        }
        float f = 6.0f;
        float f1 = 6.0f / (float)pRadius;
        for (float f2 = 0.0f; f2 < (float)Math.PI * 2; f2 += f1) {
            int j;
            int i = (int)(Mth.cos((float)f2) * (float)pRadius);
            if (!MuscleUtils.isEmptyOrWaterOrLava((LevelAccessor)pLevel, pPos.offset(i, 0, j = (int)(Mth.sin((float)f2) * (float)pRadius)))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyOrWater(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, MuscleUtils::isEmptyOrWater);
    }

    public static boolean isEmptyOrWaterOrLava(LevelAccessor pLevel, BlockPos pPos) {
        return pLevel.isStateAtPosition(pPos, MuscleUtils::isEmptyOrWaterOrLava);
    }

    protected static boolean placeMuscleBlockIfPossible(LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = pLevel.getBlockState(pPos);
        if (blockstate.is((Block)CCBlocks.FLESH_BLOCK.get())) {
            pLevel.setBlock(pPos, ((Block)CCBlocks.MUSCLE_BLOCK.get()).defaultBlockState(), 2);
            return true;
        }
        return false;
    }

    public static boolean isMuscleBaseOrLava(BlockState pState) {
        return MuscleUtils.isMuscleBase(pState) || pState.is(Blocks.LAVA);
    }

    public static boolean isMuscleBase(BlockState pState) {
        return pState.is((Block)CCBlocks.MUSCLE_BLOCK.get()) || pState.is((Block)CCBlocks.FLESH_BLOCK.get());
    }

    public static boolean isEmptyOrWater(BlockState p_159665_) {
        return p_159665_.isAir() || p_159665_.is(Blocks.WATER);
    }

    public static boolean isNeitherEmptyNorWater(BlockState pState) {
        return !pState.isAir() && !pState.is(Blocks.WATER);
    }

    public static boolean isEmptyOrWaterOrLava(BlockState p_159667_) {
        return p_159667_.isAir() || p_159667_.is(Blocks.WATER) || p_159667_.is(Blocks.LAVA);
    }
}

