/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.fluid;

import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.veroxuniverse.crystal_chronicles.block.BloodFluidBlock;
import net.veroxuniverse.crystal_chronicles.fluid.CCFluidTypes;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;
import net.veroxuniverse.crystal_chronicles.registry.CCItems;

public class CCFluids {
    public static final DeferredRegister<Fluid> FLUIDS = DeferredRegister.create((Registry)BuiltInRegistries.FLUID, (String)"crystal_chronicles");
    public static final Supplier<FlowingFluid> SOURCE_BLOOD = FLUIDS.register("source_blood", () -> new BaseFlowingFluid.Source(BLOOD_PROPERTIES));
    public static final Supplier<FlowingFluid> FLOWING_BLOOD = FLUIDS.register("flowing_blood", () -> new BaseFlowingFluid.Flowing(BLOOD_PROPERTIES));
    public static final DeferredBlock<LiquidBlock> BLOOD_BLOCK = CCBlocks.BLOCKS.register("blood_block", () -> new BloodFluidBlock(SOURCE_BLOOD.get(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.WATER).noLootTable()));
    public static final DeferredItem<Item> BLOOD_BUCKET = CCItems.ITEMS.registerItem("blood_bucket", properties -> new BucketItem((Fluid)SOURCE_BLOOD.get(), properties.craftRemainder(Items.BUCKET).stacksTo(1)));
    public static final BaseFlowingFluid.Properties BLOOD_PROPERTIES = new BaseFlowingFluid.Properties(CCFluidTypes.BLOOD_FLUID_TYPE, SOURCE_BLOOD, FLOWING_BLOOD).slopeFindDistance(2).levelDecreasePerBlock(1).block(BLOOD_BLOCK).bucket(BLOOD_BUCKET).explosionResistance(10.0f);

    public static void register(IEventBus eventBus) {
        FLUIDS.register(eventBus);
    }
}

