/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import net.minecraft.core.BlockPos;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;

public class FleshBlock
extends Block {
    public static final BooleanProperty HAS_SKIN_ABOVE = BooleanProperty.create((String)"has_skin_above");

    public FleshBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_SKIN_ABOVE, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos posAbove = context.getClickedPos().above();
        boolean hasSkinAbove = level.getBlockState(posAbove).is((Block)CCBlocks.SKIN_LAYER.get());
        return (BlockState)this.defaultBlockState().setValue((Property)HAS_SKIN_ABOVE, (Comparable)Boolean.valueOf(hasSkinAbove));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide()) {
            boolean hasSkinAbove = level.getBlockState(pos.above()).is((Block)CCBlocks.SKIN_LAYER.get());
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_SKIN_ABOVE, (Comparable)Boolean.valueOf(hasSkinAbove)), 3);
        }
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.neighborChanged(state, level, pos, block, fromPos, isMoving);
        if (!level.isClientSide()) {
            boolean hasSkinAbove = level.getBlockState(pos.above()).is((Block)CCBlocks.SKIN_LAYER.get());
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_SKIN_ABOVE, (Comparable)Boolean.valueOf(hasSkinAbove)), 3);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{HAS_SKIN_ABOVE});
    }
}

