/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CleverLightBlock
extends Block {
    public static final BooleanProperty LIT = RedstoneTorchBlock.LIT;

    public CleverLightBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, 20);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        super.tick(pState, pLevel, pPos, pRandom);
        boolean isPlayerNearby = this.isPlayerNearby(pLevel, pPos, 10.0);
        if (isPlayerNearby && !((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 3);
            pLevel.updateNeighborsAt(pPos, (Block)this);
        } else if (!isPlayerNearby && ((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 3);
            pLevel.updateNeighborsAt(pPos, (Block)this);
        }
        pLevel.scheduleTick(pPos, (Block)this, 10);
    }

    private boolean isPlayerNearby(ServerLevel pLevel, BlockPos pPos, double radius) {
        AABB boundingBox = new AABB(pPos).inflate(radius);
        List players = pLevel.getEntitiesOfClass(Player.class, boundingBox);
        return !players.isEmpty();
    }

    public int getSignal(BlockState pBlockState, BlockGetter pBlockAccess, BlockPos pPos, Direction pSide) {
        return (Boolean)pBlockState.getValue((Property)LIT) != false ? 15 : 0;
    }

    public boolean isSignalSource(BlockState pBlockState) {
        return true;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }
}

