/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BronchusBlock
extends Block {
    public static final DirectionProperty FACING = BlockStateProperties.FACING;

    public BronchusBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        switch (direction) {
            default: {
                return this.makeShapeNorthSouth();
            }
            case SOUTH: {
                return this.makeShapeNorthSouth();
            }
            case EAST: 
            case WEST: {
                return this.makeShapeEastWest();
            }
            case DOWN: 
            case UP: 
        }
        return this.makeShapeUpDown();
    }

    public VoxelShape makeShapeUpDown() {
        VoxelShape shape1 = Shapes.empty();
        shape1 = Shapes.join((VoxelShape)shape1, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape1 = Shapes.join((VoxelShape)shape1, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape1 = Shapes.join((VoxelShape)shape1, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.125, (double)1.0, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape1 = Shapes.join((VoxelShape)shape1, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)0.125, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape1;
    }

    public VoxelShape makeShapeEastWest() {
        VoxelShape shape2 = Shapes.empty();
        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.125), (BooleanOp)BooleanOp.OR);
        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.875, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)Shapes.box((double)0.0, (double)0.875, (double)0.125, (double)1.0, (double)1.0, (double)0.875), (BooleanOp)BooleanOp.OR);
        shape2 = Shapes.join((VoxelShape)shape2, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)0.125, (double)0.875), (BooleanOp)BooleanOp.OR);
        return shape2;
    }

    public VoxelShape makeShapeNorthSouth() {
        VoxelShape shape3 = Shapes.empty();
        shape3 = Shapes.join((VoxelShape)shape3, (VoxelShape)Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.125, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape3 = Shapes.join((VoxelShape)shape3, (VoxelShape)Shapes.box((double)0.875, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape3 = Shapes.join((VoxelShape)shape3, (VoxelShape)Shapes.box((double)0.125, (double)0.875, (double)0.0, (double)0.875, (double)1.0, (double)1.0), (BooleanOp)BooleanOp.OR);
        shape3 = Shapes.join((VoxelShape)shape3, (VoxelShape)Shapes.box((double)0.125, (double)0.0, (double)0.0, (double)0.875, (double)0.125, (double)1.0), (BooleanOp)BooleanOp.OR);
        return shape3;
    }

    protected BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        return pDirection == ((Direction)pState.getValue((Property)FACING)).getOpposite() && !pState.canSurvive((LevelReader)pLevel, pPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pDirection, pNeighborState, pLevel, pPos, pNeighborPos);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getClickedFace());
    }

    protected BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        switch (direction) {
            default: {
                return this.makeShapeNorthSouth();
            }
            case SOUTH: {
                return this.makeShapeNorthSouth();
            }
            case EAST: 
            case WEST: {
                return this.makeShapeEastWest();
            }
            case DOWN: 
            case UP: 
        }
        return this.makeShapeUpDown();
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.getValue((Property)FACING);
        switch (direction) {
            default: {
                return this.makeShapeNorthSouth();
            }
            case SOUTH: {
                return this.makeShapeNorthSouth();
            }
            case EAST: 
            case WEST: {
                return this.makeShapeEastWest();
            }
            case DOWN: 
            case UP: 
        }
        return this.makeShapeUpDown();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING});
    }
}

