/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.veroxuniverse.crystal_chronicles.block.NeuronBlock;
import org.jetbrains.annotations.NotNull;

public class AxonBlock
extends HalfTransparentBlock {
    public static final VoxelShape SHAPE_BASE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public AxonBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            this.updateBlocks(pLevel, pPos);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        this.updateBlocks((Level)pLevel, pPos);
        pLevel.scheduleTick(pPos, (Block)this, 10);
    }

    private void updateBlocks(Level pLevel, BlockPos pPos) {
        BlockPos blockBelow = pPos.below();
        BlockState belowState = pLevel.getBlockState(blockBelow);
        if (belowState.getBlock() instanceof NeuronBlock) {
            boolean shouldBeLit = (Boolean)belowState.getValue((Property)NeuronBlock.LIT);
            BlockState currentState = pLevel.getBlockState(pPos);
            if ((Boolean)currentState.getValue((Property)LIT) != shouldBeLit) {
                pLevel.setBlock(pPos, (BlockState)currentState.setValue((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }

    public boolean isSignalSource(BlockState state) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_BASE;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BASE;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return SHAPE_BASE;
    }
}

