/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nick.chimes.ChimesStates;
import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.entity.WindChimeBE;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class IronBERenderer
implements BlockEntityRenderer<WindChimeBE.IronBE> {
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty SILENCED = ChimesStates.SILENCED;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static ModelLayerLocation IRON_CHIMES_LAYER = new ModelLayerLocation(ResourceLocation.tryBuild((String)"chimes", (String)"block/metal_chimes"), "Chimes");
    public static final Material IRON = new Material(TextureAtlas.LOCATION_BLOCKS, ResourceLocation.tryBuild((String)"chimes", (String)"block/metal_chimes"));
    private final ModelPart MetalTopper;
    private final ModelPart Topper;
    private final ModelPart TopperBoneA;
    private final ModelPart BigStrA;
    private final ModelPart BigA;
    private final ModelPart SmaStrA;
    private final ModelPart SmaA;
    private final ModelPart MedStrA;
    private final ModelPart MedA;
    private final ModelPart LarStrA;
    private final ModelPart LarA;
    private final ModelPart MetalLower;
    private final ModelPart TopperBoneB;
    private final ModelPart LarStrB;
    private final ModelPart LarB;
    private final ModelPart BigStrB;
    private final ModelPart BigB;
    private final ModelPart MedStrB;
    private final ModelPart MedB;
    private final ModelPart SmaStrB;
    private final ModelPart SmaB;
    private final ModelPart TopperBone;

    public IronBERenderer(BlockEntityRendererProvider.Context context) {
        ModelPart root = context.bakeLayer(IRON_CHIMES_LAYER);
        BlockEntityRenderDispatcher renderer = context.getBlockEntityRenderDispatcher();
        this.MetalTopper = root.getChild("MetalTopper");
        this.Topper = this.MetalTopper.getChild("Topper");
        this.TopperBoneA = this.Topper.getChild("TopperBoneA");
        this.BigStrA = this.TopperBoneA.getChild("BigStrA");
        this.BigA = this.BigStrA.getChild("BigA");
        this.SmaStrA = this.TopperBoneA.getChild("SmaStrA");
        this.SmaA = this.SmaStrA.getChild("SmaA");
        this.MedStrA = this.TopperBoneA.getChild("MedStrA");
        this.MedA = this.MedStrA.getChild("MedA");
        this.LarStrA = this.TopperBoneA.getChild("LarStrA");
        this.LarA = this.LarStrA.getChild("LarA");
        this.MetalLower = root.getChild("MetalLower");
        this.TopperBoneB = this.MetalLower.getChild("TopperBoneB");
        this.LarStrB = this.TopperBoneB.getChild("LarStrB");
        this.LarB = this.LarStrB.getChild("LarB");
        this.BigStrB = this.TopperBoneB.getChild("BigStrB");
        this.BigB = this.BigStrB.getChild("BigB");
        this.MedStrB = this.TopperBoneB.getChild("MedStrB");
        this.MedB = this.MedStrB.getChild("MedB");
        this.SmaStrB = this.TopperBoneB.getChild("SmaStrB");
        this.SmaB = this.SmaStrB.getChild("SmaB");
        this.TopperBone = root.getChild("TopperBone");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition MetalTopper = partdefinition.addOrReplaceChild("MetalTopper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Topper = MetalTopper.addOrReplaceChild("Topper", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition TopperBoneA = Topper.addOrReplaceChild("TopperBoneA", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition BigStrA = TopperBoneA.addOrReplaceChild("BigStrA", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigA = BigStrA.addOrReplaceChild("BigA", CubeListBuilder.create().texOffs(8, 12).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaStrA = TopperBoneA.addOrReplaceChild("SmaStrA", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaA = SmaStrA.addOrReplaceChild("SmaA", CubeListBuilder.create().texOffs(24, 12).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition MedStrA = TopperBoneA.addOrReplaceChild("MedStrA", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedA = MedStrA.addOrReplaceChild("MedA", CubeListBuilder.create().texOffs(16, 12).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarStrA = TopperBoneA.addOrReplaceChild("LarStrA", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarA = LarStrA.addOrReplaceChild("LarA", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, 0.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition MetalLower = partdefinition.addOrReplaceChild("MetalLower", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition TopperBoneB = MetalLower.addOrReplaceChild("TopperBoneB", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition LarStrB = TopperBoneB.addOrReplaceChild("LarStrB", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarB = LarStrB.addOrReplaceChild("LarB", CubeListBuilder.create().texOffs(0, 23).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 13.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition BigStrB = TopperBoneB.addOrReplaceChild("BigStrB", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigB = BigStrB.addOrReplaceChild("BigB", CubeListBuilder.create().texOffs(8, 23).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition MedStrB = TopperBoneB.addOrReplaceChild("MedStrB", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedB = MedStrB.addOrReplaceChild("MedB", CubeListBuilder.create().texOffs(16, 23).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaStrB = TopperBoneB.addOrReplaceChild("SmaStrB", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaB = SmaStrB.addOrReplaceChild("SmaB", CubeListBuilder.create().texOffs(24, 23).addBox(-1.0f, 9.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition TopperBone = partdefinition.addOrReplaceChild("TopperBone", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)8.0f, (float)0.0f));
        PartDefinition Chain1_r1 = TopperBone.addOrReplaceChild("Chain1_r1", CubeListBuilder.create().texOffs(32, 3).addBox(-1.5f, 0.0f, 0.0f, 3.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)3.0f, (float)0.0f, (float)0.0f, (float)-0.7854f, (float)0.0f));
        PartDefinition Chain_r1 = TopperBone.addOrReplaceChild("Chain_r1", CubeListBuilder.create().texOffs(32, 0).addBox(-1.5f, -4.0f, 0.0f, 3.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)4.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneBase = TopperBone.addOrReplaceChild("TopperBoneBase", CubeListBuilder.create().texOffs(0, 0).addBox(-5.0f, 0.0f, -5.0f, 10.0f, 2.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)4.0f, (float)0.0f));
        PartDefinition TopperStringLar = TopperBoneBase.addOrReplaceChild("TopperStringLar", CubeListBuilder.create(), PartPose.offset((float)-3.0f, (float)2.0f, (float)0.0f));
        PartDefinition LarString_r1 = TopperStringLar.addOrReplaceChild("LarString_r1", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperStringBig = TopperBoneBase.addOrReplaceChild("TopperStringBig", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)-3.0f));
        PartDefinition BigString_r1 = TopperStringBig.addOrReplaceChild("BigString_r1", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneSma = TopperBoneBase.addOrReplaceChild("TopperBoneSma", CubeListBuilder.create(), PartPose.offset((float)3.0f, (float)2.0f, (float)0.0f));
        PartDefinition SmaString_r1 = TopperBoneSma.addOrReplaceChild("SmaString_r1", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        PartDefinition TopperBoneMed = TopperBoneBase.addOrReplaceChild("TopperBoneMed", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)2.0f, (float)3.0f));
        PartDefinition MedString_r1 = TopperBoneMed.addOrReplaceChild("MedString_r1", CubeListBuilder.create().texOffs(38, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)1.0f, (float)0.0f, (float)0.0f, (float)0.7854f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(WindChimeBE.IronBE tileEntityIn, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        VertexConsumer ivertexbuilder = IRON.buffer(bufferIn, RenderType::entityCutout);
        BlockState blockstate = tileEntityIn.getBlockState();
        Direction flag3 = (Direction)blockstate.getValue((Property)FACING);
        BlockPos pos = tileEntityIn.getBlockPos();
        float a = 1.0f;
        float f3 = 1.0f;
        if ((float)tileEntityIn.velocityTicks <= 0.0f || (float)tileEntityIn.velocityTicks >= 2.0f) {
            f3 = (float)tileEntityIn.velocityTicks * 0.25f;
        }
        if ((float)tileEntityIn.velocityTicks >= 0.0f && (float)tileEntityIn.velocityTicks <= 2.0f) {
            if (blockstate.getValue((Property)SILENCED) == Boolean.FALSE) {
                f3 = ((float)tileEntityIn.velocityTicks + partialTicks) * 0.25f;
            }
            if (blockstate.getValue((Property)SILENCED) == Boolean.TRUE) {
                f3 = ((float)tileEntityIn.velocityTicks - partialTicks) * 0.25f;
            }
        }
        float s1 = 1.0f;
        if (tileEntityIn.silenceTicks <= 0 || tileEntityIn.silenceTicks >= 200) {
            s1 = 0.0f;
        }
        if (tileEntityIn.silenceTicks >= 0 && tileEntityIn.silenceTicks <= 200 && blockstate.getValue((Property)SILENCED) == Boolean.TRUE) {
            s1 = (float)tileEntityIn.silenceTicks + partialTicks;
        }
        float f = (float)tileEntityIn.interactTicks + partialTicks;
        assert (Minecraft.getInstance().player != null);
        float f1 = (float)Minecraft.getInstance().player.tickCount + partialTicks + (float)(pos.getX() * 7) + (float)(pos.getZ() * 13);
        float f4 = Mth.sin((float)(f / (float)Math.PI)) / (9.0f + f / 2.9f);
        float f5 = Mth.sin((float)(f * 1.5f / (float)Math.PI)) / (5.0f + f / 2.9f);
        float f04 = Mth.sin((float)(f * 1.15f / (float)Math.PI)) / (9.0f + f / 1.9f);
        float f05 = Mth.sin((float)(f * 1.25f / (float)Math.PI)) / (10.0f + f / 5.9f);
        float wind = (float)(Math.sin((double)f1 * 2.0E-4) * (double)0.2f + Math.sin(f1 * 0.005f) * (double)0.3f + (double)0.9f);
        float f15 = (float)Math.sin((double)f1 * 0.04) * 0.35f;
        float f10 = (float)Math.sin((double)f1 * 0.018) * 0.48f;
        float f1o = (float)Math.sin((double)f1 * 0.12) * (0.05f * wind) * f3;
        float f2o = (float)Math.cos((double)f1 * 0.12) * (0.05f * wind) * f3;
        float f11 = (float)(Math.sin((double)f1 * 0.11) * (double)0.02f * (double)wind) * f3;
        float f12 = (float)(Math.sin((double)f1 * 0.13) * (double)0.024f * (double)wind) * f3;
        float f13 = (float)(Math.sin((double)f1 * 0.15) * (double)0.028f * (double)wind) * f3;
        float f14 = (float)(Math.sin((double)f1 * 0.17) * (double)0.04f * (double)wind) * f3;
        float f111 = (float)(Math.cos((double)f1 * 0.11) * (double)0.02f * (double)wind) * f3;
        float f121 = (float)(Math.cos((double)f1 * 0.13) * (double)0.014f * (double)wind) * f3;
        float f131 = (float)(Math.cos((double)f1 * 0.15) * (double)0.028f * (double)wind) * f3;
        float f141 = (float)(Math.cos((double)f1 * 0.17) * (double)0.04f * (double)wind) * f3;
        this.MetalTopper.xRot = (float)Math.PI;
        this.MetalLower.xRot = (float)Math.PI;
        this.TopperBone.xRot = (float)Math.PI;
        this.MetalTopper.setPos(8.0f, 16.0f, 8.0f);
        this.MetalLower.setPos(8.0f, 32.0f, 8.0f);
        this.TopperBone.setPos(8.0f, 16.0f, 8.0f);
        if (flag3.equals((Object)Direction.NORTH)) {
            this.TopperBoneB.yRot = 0.0f;
            this.TopperBoneA.yRot = 0.0f;
        }
        if (flag3.equals((Object)Direction.EAST)) {
            this.TopperBoneB.yRot = 7.853982f;
            this.TopperBoneA.yRot = 7.853982f;
        }
        if (flag3.equals((Object)Direction.SOUTH)) {
            this.TopperBoneB.yRot = (float)Math.PI;
            this.TopperBoneA.yRot = (float)Math.PI;
        }
        if (flag3.equals((Object)Direction.WEST)) {
            this.TopperBoneB.yRot = 4.712389f;
            this.TopperBoneA.yRot = 4.712389f;
        }
        float LarX = f111 + f1o;
        float LarY = f15;
        float LarZ = f11 + f2o / 5.0f;
        float BigX = f121 + f1o;
        float BigY = (float)Math.sin((double)f1 * 0.01) * 0.45f;
        float BigZ = f12 + f2o / 5.0f;
        float MedX = f131 + f1o;
        float MedY = (float)Math.sin((double)f1 * 0.028) * 0.8f;
        float MedZ = f13 + f2o / 5.0f;
        float SmaX = f141 + f1o;
        float SmaY = -f10;
        float SmaZ = f14 + f2o / 5.0f;
        if (flag3.equals((Object)Direction.EAST) || flag3.equals((Object)Direction.WEST)) {
            LarX = f11 + f2o / 5.0f;
            LarZ = f111 + f1o;
            BigX = f12 + f2o / 5.0f;
            BigZ = f121 + f1o;
            MedX = f13 + f2o / 5.0f;
            MedZ = f131 + f1o;
            SmaX = f14 + f2o / 5.0f;
            SmaZ = f141 + f1o;
        }
        if (tileEntityIn.isSwinging && blockstate.getValue((Property)SILENCED) == Boolean.FALSE) {
            SmaZ = f5 / 1.5f;
            LarZ = -f4 / 1.5f;
            MedX = -f05 / 1.5f;
            BigX = f04 / 1.5f;
        }
        this.LarA.xRot = this.LarB.xRot = LarX * a;
        this.LarA.yRot = this.LarB.yRot = LarY * a;
        this.LarA.zRot = this.LarB.zRot = LarZ * a;
        this.BigA.xRot = this.BigB.xRot = BigX * a;
        this.BigA.yRot = this.BigB.yRot = BigY * a;
        this.BigA.zRot = this.BigB.zRot = BigZ * a;
        this.MedA.xRot = this.MedB.xRot = MedX * a;
        this.MedA.yRot = this.MedB.yRot = MedY * a;
        this.MedA.zRot = this.MedB.zRot = MedZ * a;
        this.SmaA.xRot = this.SmaB.xRot = SmaX * a;
        this.SmaA.yRot = this.SmaB.yRot = SmaY * a;
        this.SmaA.zRot = this.SmaB.zRot = SmaZ * a;
        this.LarB.y = 1.0f;
        this.LarA.y = 1.0f;
        this.BigB.y = 2.0f;
        this.BigA.y = 2.0f;
        this.MedB.y = 2.0f;
        this.MedA.y = 2.0f;
        this.SmaB.y = 1.0f;
        this.SmaA.y = 1.0f;
        if (blockstate.is((Block)ChimesBlocks.METALCHIMES)) {
            if (blockstate.getValue(HALF) == DoubleBlockHalf.UPPER) {
                this.MetalTopper.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
                this.TopperBone.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            } else {
                this.MetalLower.render(matrixStackIn, ivertexbuilder, combinedLightIn, combinedOverlayIn);
            }
        }
    }

    public int getViewDistance() {
        return 100;
    }
}

