/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.neoforge.event;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.neoforge.ChimesBlocksNeoForge;
import com.nick.chimes.particle.ChimesParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@EventBusSubscriber(modid="chimes", bus=EventBusSubscriber.Bus.GAME)
public class CarveBambooEvent {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void rightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        if (!event.getLevel().isClientSide) {
            // empty if block
        }
        if (event.getEntity() instanceof Player) {
            Level world = event.getLevel();
            BlockPos pos = event.getPos();
            BlockState state = world.getBlockState(pos);
            BlockState stateAbove = world.getBlockState(pos.above());
            BlockState stateBelow = world.getBlockState(pos.below());
            if (player.getItemInHand(event.getHand()).getItem() instanceof AxeItem && state.is((Block)ChimesBlocksNeoForge.BAMBOOCHIMES.get())) {
                boolean carvedUpper = state.getValue(HALF) == DoubleBlockHalf.UPPER && stateBelow.is((Block)ChimesBlocksNeoForge.BAMBOOCHIMES.get());
                boolean carvedLower = state.getValue(HALF) == DoubleBlockHalf.LOWER && stateAbove.is((Block)ChimesBlocksNeoForge.BAMBOOCHIMES.get());
                for (int i = 5; i <= 10; ++i) {
                    world.addParticle((ParticleOptions)ChimesParticles.LEAF, (double)event.getHitVec().getBlockPos().getX() + Math.random(), (double)event.getHitVec().getBlockPos().getY() + Math.random(), (double)event.getHitVec().getBlockPos().getZ() + Math.random(), 0.0, -0.005, 0.0);
                }
                if (carvedUpper) {
                    world.setBlock(pos.below(), (BlockState)ChimesBlocksNeoForge.STRIPPEDBAMBOOCHIMES.get().withPropertiesOf(stateBelow).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.valueOf(false)), 35);
                } else if (carvedLower) {
                    world.setBlock(pos.above(), (BlockState)ChimesBlocksNeoForge.STRIPPEDBAMBOOCHIMES.get().withPropertiesOf(stateAbove).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.valueOf(false)), 35);
                }
                world.setBlock(pos, (BlockState)ChimesBlocksNeoForge.STRIPPEDBAMBOOCHIMES.get().withPropertiesOf(state).setValue((Property)ChimesStates.SILENCED, (Comparable)Boolean.valueOf(false)), 35);
                world.playSound(null, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 0.9f);
                world.playSound(null, pos, SoundEvents.AXE_STRIP, SoundSource.BLOCKS, 1.0f, 0.9f);
                player.swing(event.getHand(), false);
                player.getItemInHand(event.getHand()).hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)event.getHand()));
            }
        }
    }
}

