/*
 * Decompiled with CFR 0.152.
 */
package com.nick.chimes.block.entity;

import com.nick.chimes.ChimesStates;
import com.nick.chimes.block.ChimesBlocks;
import com.nick.chimes.block.WindChimeTyableBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.monster.Phantom;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class WindChimeBE
extends BlockEntity {
    public int interactTicks;
    public int velocityTicks;
    public int silenceTicks;
    public boolean isSwinging;

    public WindChimeBE(BlockEntityType<?> tileEntityTypeIn, BlockPos p_155173_, BlockState p_155174_) {
        super(tileEntityTypeIn, p_155173_, p_155174_);
    }

    public boolean triggerEvent(int id, int type) {
        if (id == 1) {
            this.interactTicks = 0;
            this.isSwinging = true;
            return true;
        }
        return super.triggerEvent(id, type);
    }

    public void tick() {
        AABB aabb = new AABB(this.getBlockPos()).inflate(20.0, 25.0, 20.0);
        List list = this.level.getEntitiesOfClass(Phantom.class, aabb);
        BlockState state = this.getBlockState();
        boolean flag = this.level.getBlockState(this.worldPosition).getBlock() instanceof WindChimeTyableBlock;
        boolean silenced = false;
        if (this.level.isLoaded(this.worldPosition)) {
            if (this.isSwinging) {
                ++this.interactTicks;
            }
            if (this.interactTicks >= 200) {
                this.isSwinging = false;
                this.interactTicks = 0;
            }
            if (state.getBlock() instanceof WindChimeTyableBlock) {
                if (!((Boolean)state.getValue((Property)ChimesStates.SILENCED)).booleanValue()) {
                    if (this.velocityTicks <= 2) {
                        ++this.velocityTicks;
                    }
                    this.silenceTicks = 0;
                } else {
                    if (!silenced) {
                        silenced = true;
                    }
                    this.isSwinging = false;
                    if (this.silenceTicks <= 200) {
                        ++this.silenceTicks;
                    }
                    if (this.velocityTicks >= 0) {
                        --this.velocityTicks;
                    }
                }
            }
            if (!list.isEmpty()) {
                for (Phantom phantom : list) {
                    if ((!flag || silenced) && flag || phantom.getTarget() == null) continue;
                    phantom.playSound(SoundEvents.PHANTOM_HURT, 0.5f, 0.0f);
                    phantom.setTarget(null);
                }
            }
        }
    }

    public void chime() {
        BlockPos blockpos = this.getBlockPos();
        if (this.isSwinging) {
            this.interactTicks = 0;
        } else {
            this.isSwinging = true;
        }
        this.level.blockEvent(blockpos, this.getBlockState().getBlock(), 1, 0);
    }

    public AABB getRenderBoundingBox() {
        return new AABB((double)this.getBlockPos().getX(), (double)(this.getBlockPos().getY() + 1), (double)this.getBlockPos().getZ(), (double)(this.getBlockPos().getX() + 1), (double)(this.getBlockPos().getY() - 2), (double)(this.getBlockPos().getZ() + 1));
    }

    public static class IronBE
    extends WindChimeBE {
        public IronBE(BlockPos p_155173_, BlockState p_155174_) {
            super(ChimesBlocks.IRON_WIND_CHIME_BLOCK_ENTITY, p_155173_, p_155174_);
        }
    }

    public static class CopperBE
    extends WindChimeBE {
        public CopperBE(BlockPos p_155173_, BlockState p_155174_) {
            super(ChimesBlocks.COPPER_WIND_CHIME_BLOCK_ENTITY, p_155173_, p_155174_);
        }
    }

    public static class BambooBE
    extends WindChimeBE {
        public BambooBE(BlockPos p_155173_, BlockState p_155174_) {
            super(ChimesBlocks.BAMBOO_WIND_CHIME_BLOCK_ENTITY, p_155173_, p_155174_);
        }
    }

    public static class AmethystBE
    extends WindChimeBE {
        public AmethystBE(BlockPos p_155173_, BlockState p_155174_) {
            super(ChimesBlocks.AMETHYST_WIND_CHIME_BLOCK_ENTITY, p_155173_, p_155174_);
        }
    }
}

