/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.util.StructurePoolHelper;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public final class FriendsAndFoesStructurePoolElements {
    public static void init(MinecraftServer server) {
        Registry templatePoolRegistry = server.registryAccess().registryOrThrow(Registries.TEMPLATE_POOL);
        ResourceLocation plainsPoolLocation = ResourceLocation.parse((String)"minecraft:village/plains/houses");
        ResourceLocation desertPoolLocation = ResourceLocation.parse((String)"minecraft:village/desert/houses");
        ResourceLocation savannaPoolLocation = ResourceLocation.parse((String)"minecraft:village/savanna/houses");
        ResourceLocation taigaPoolLocation = ResourceLocation.parse((String)"minecraft:village/taiga/houses");
        ResourceLocation ancientCityCenterPoolLocation = ResourceLocation.parse((String)"minecraft:ancient_city/city_center");
        ResourceLocation trialChambersCorridorPoolLocation = ResourceLocation.parse((String)"minecraft:trial_chambers/corridor");
        if (FriendsAndFoes.getConfig().generateBeekeeperAreaStructureInVillages) {
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, plainsPoolLocation, "village/plains/houses/plains_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, savannaPoolLocation, "village/savanna/houses/savanna_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, taigaPoolLocation, "village/taiga/houses/taiga_beekeeper_area", FriendsAndFoes.getConfig().beekeeperAreaStructureWeight);
        }
        if (FriendsAndFoes.getConfig().enableCopperGolemsInTrialChambers) {
            StructurePoolHelper.addSingleElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, trialChambersCorridorPoolLocation, "trial_chambers/corridor/entrance_1_copper_golem", FriendsAndFoes.getConfig().copperGolemInTrialChambersWeight);
            StructurePoolHelper.addSingleElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, trialChambersCorridorPoolLocation, "trial_chambers/corridor/entrance_2_copper_golem", FriendsAndFoes.getConfig().copperGolemInTrialChambersWeight);
            StructurePoolHelper.addSingleElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, trialChambersCorridorPoolLocation, "trial_chambers/corridor/entrance_3_copper_golem", FriendsAndFoes.getConfig().copperGolemInTrialChambersWeight);
        }
        if (FriendsAndFoes.getConfig().generateCopperGolemWorkstationStructureInVillages) {
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, plainsPoolLocation, "village/plains/houses/plains_copper_golem_area", FriendsAndFoes.getConfig().copperGolemWorkstationStructureWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, desertPoolLocation, "village/desert/houses/desert_copper_golem_area", FriendsAndFoes.getConfig().copperGolemWorkstationStructureWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, savannaPoolLocation, "village/savanna/houses/savanna_copper_golem_area", FriendsAndFoes.getConfig().copperGolemWorkstationStructureWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, taigaPoolLocation, "village/taiga/houses/taiga_copper_golem_area", FriendsAndFoes.getConfig().copperGolemWorkstationStructureWeight);
        }
        if (FriendsAndFoes.getConfig().generateCopperGolemInAncientCity) {
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_1", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_2", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
            StructurePoolHelper.addLegacyElementToPool((Registry<StructureTemplatePool>)templatePoolRegistry, ancientCityCenterPoolLocation, "ancient_city/city_center/city_center_3", FriendsAndFoes.getConfig().copperGolemAncientCityCenterWeight);
        }
    }

    private FriendsAndFoesStructurePoolElements() {
    }
}

