/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.init;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.config.FriendsAndFoesConfig;
import com.faboslav.friendsandfoes.common.entity.CopperGolemEntity;
import com.faboslav.friendsandfoes.common.entity.CrabEntity;
import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerEntity;
import com.faboslav.friendsandfoes.common.entity.IceologerIceChunkEntity;
import com.faboslav.friendsandfoes.common.entity.IllusionerEntity;
import com.faboslav.friendsandfoes.common.entity.MaulerEntity;
import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.entity.PlayerIllusionEntity;
import com.faboslav.friendsandfoes.common.entity.RascalEntity;
import com.faboslav.friendsandfoes.common.entity.TuffGolemEntity;
import com.faboslav.friendsandfoes.common.entity.WildfireEntity;
import com.faboslav.friendsandfoes.common.events.lifecycle.AddSpawnBiomeModificationsEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntityAttributesEvent;
import com.faboslav.friendsandfoes.common.events.lifecycle.RegisterEntitySpawnRestrictionsEvent;
import com.faboslav.friendsandfoes.common.platform.CustomSpawnGroup;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.versions.VersionedEntityTypeResourceId;
import com.teamresourceful.resourcefullib.common.registry.RegistryEntry;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistries;
import com.teamresourceful.resourcefullib.common.registry.ResourcefulRegistry;
import net.minecraft.SharedConstants;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.levelgen.Heightmap;

public final class FriendsAndFoesEntityTypes {
    public static final ResourcefulRegistry<EntityType<?>> ENTITY_TYPES = ResourcefulRegistries.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"friendsandfoes");
    public static boolean previousUseChoiceTypeRegistrations = SharedConstants.CHECK_DATA_FIXER_SCHEMA;
    public static final RegistryEntry<EntityType<CopperGolemEntity>> COPPER_GOLEM;
    public static final RegistryEntry<EntityType<CrabEntity>> CRAB;
    public static final RegistryEntry<EntityType<GlareEntity>> GLARE;
    public static final RegistryEntry<EntityType<IceologerEntity>> ICEOLOGER;
    public static final RegistryEntry<EntityType<IllusionerEntity>> ILLUSIONER;
    public static final RegistryEntry<EntityType<IceologerIceChunkEntity>> ICE_CHUNK;
    public static final RegistryEntry<EntityType<MaulerEntity>> MAULER;
    public static final RegistryEntry<EntityType<MoobloomEntity>> MOOBLOOM;
    public static final RegistryEntry<EntityType<RascalEntity>> RASCAL;
    public static final RegistryEntry<EntityType<TuffGolemEntity>> TUFF_GOLEM;
    public static final RegistryEntry<EntityType<WildfireEntity>> WILDFIRE;
    public static final RegistryEntry<EntityType<PlayerIllusionEntity>> PLAYER_ILLUSION;

    public static void registerEntityAttributes(RegisterEntityAttributesEvent event) {
        event.register((EntityType<? extends LivingEntity>)((EntityType)COPPER_GOLEM.get()), CopperGolemEntity.createCopperGolemAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)CRAB.get()), CrabEntity.createCrabAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)GLARE.get()), GlareEntity.createGlareAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)ICEOLOGER.get()), IceologerEntity.createIceologerAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)ILLUSIONER.get()), IllusionerEntity.createAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)MAULER.get()), MaulerEntity.createMaulerAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)MOOBLOOM.get()), MoobloomEntity.createAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)RASCAL.get()), RascalEntity.createRascalAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)TUFF_GOLEM.get()), TuffGolemEntity.createTuffGolemAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)WILDFIRE.get()), WildfireEntity.createWildfireAttributes());
        event.register((EntityType<? extends LivingEntity>)((EntityType)PLAYER_ILLUSION.get()), PlayerIllusionEntity.createMobAttributes());
    }

    public static void registerEntitySpawnRestrictions(RegisterEntitySpawnRestrictionsEvent event) {
        event.register((EntityType)CRAB.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, CrabEntity::canSpawn);
        event.register((EntityType)GLARE.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, GlareEntity::canSpawn);
        event.register((EntityType)ICEOLOGER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::checkPatrollingMonsterSpawnRules);
        event.register((EntityType)ILLUSIONER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PatrollingMonster::checkPatrollingMonsterSpawnRules);
        event.register((EntityType)MAULER.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MaulerEntity::canSpawn);
        event.register((EntityType)MOOBLOOM.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, MoobloomEntity::canSpawn);
        event.register((EntityType)RASCAL.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, RascalEntity::canSpawn);
    }

    public static void addSpawnBiomeModifications(AddSpawnBiomeModificationsEvent event) {
        FriendsAndFoesConfig config = FriendsAndFoes.getConfig();
        if (config.enableCrab && config.enableCrabSpawn) {
            event.add(FriendsAndFoesTags.HAS_CRAB, MobCategory.CREATURE, (EntityType)CRAB.get(), config.crabSpawnWeight, config.crabSpawnMinGroupSize, config.crabSpawnMaxGroupSize);
        }
        if (config.enableGlare && config.enableGlareSpawn) {
            event.add(FriendsAndFoesTags.HAS_GLARE, CustomSpawnGroup.getGlaresCategory(), (EntityType)GLARE.get(), config.glareSpawnWeight, config.glareSpawnMinGroupSize, config.glareSpawnMaxGroupSize);
        }
        if (config.enableMauler && config.enableMaulerSpawn) {
            if (config.enableMaulerSpawnInBadlands) {
                event.add(FriendsAndFoesTags.HAS_BADLANDS_MAULER, MobCategory.CREATURE, (EntityType)MAULER.get(), config.maulerBadlandsSpawnWeight, config.maulerBadlandsSpawnMinGroupSize, config.maulerBadlandsSpawnMaxGroupSize);
            }
            if (config.enableMaulerSpawnInDesert) {
                event.add(FriendsAndFoesTags.HAS_DESERT_MAULER, MobCategory.CREATURE, (EntityType)MAULER.get(), config.maulerDesertSpawnWeight, config.maulerDesertSpawnMinGroupSize, config.maulerDesertSpawnMaxGroupSize);
            }
            if (config.enableMaulerSpawnInSavanna) {
                event.add(FriendsAndFoesTags.HAS_SAVANNA_MAULER, MobCategory.CREATURE, (EntityType)MAULER.get(), config.maulerSavannaSpawnWeight, config.maulerSavannaSpawnMinGroupSize, config.maulerSavannaSpawnMaxGroupSize);
            }
        }
        if (config.enableMoobloom && config.enableMoobloomSpawn) {
            event.add(FriendsAndFoesTags.HAS_MOOBLOOMS, MobCategory.CREATURE, (EntityType)MOOBLOOM.get(), config.moobloomSpawnWeight, config.moobloomSpawnMinGroupSize, config.moobloomSpawnMaxGroupSize);
        }
        if (config.enableRascal && config.enableRascalSpawn) {
            event.add(FriendsAndFoesTags.HAS_RASCAL, CustomSpawnGroup.getRascalsCategory(), (EntityType)RASCAL.get(), config.rascalSpawnWeight, config.rascalSpawnMinGroupSize, config.rascalSpawnMaxGroupSize);
        }
    }

    private FriendsAndFoesEntityTypes() {
    }

    static {
        SharedConstants.CHECK_DATA_FIXER_SCHEMA = false;
        COPPER_GOLEM = ENTITY_TYPES.register("copper_golem", () -> EntityType.Builder.of(CopperGolemEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 1.375f).eyeHeight(0.75f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("copper_golem")));
        CRAB = ENTITY_TYPES.register("crab", () -> EntityType.Builder.of(CrabEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.875f, 0.5625f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("crab")));
        GLARE = ENTITY_TYPES.register("glare", () -> EntityType.Builder.of(GlareEntity::new, (MobCategory)CustomSpawnGroup.getGlaresCategory()).sized(0.875f, 1.1875f).clientTrackingRange(8).updateInterval(2).build(VersionedEntityTypeResourceId.create("glare")));
        ICEOLOGER = ENTITY_TYPES.register("iceologer", () -> EntityType.Builder.of(IceologerEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("iceologer")));
        ILLUSIONER = ENTITY_TYPES.register("illusioner", () -> EntityType.Builder.of(IllusionerEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.6f, 1.95f).passengerAttachments(new float[]{2.0f}).ridingOffset(-0.6f).clientTrackingRange(8).build(VersionedEntityTypeResourceId.create("illusioner")));
        ICE_CHUNK = ENTITY_TYPES.register("ice_chunk", () -> EntityType.Builder.of(IceologerIceChunkEntity::new, (MobCategory)MobCategory.MISC).fireImmune().sized(2.5f, 1.0f).clientTrackingRange(6).build(VersionedEntityTypeResourceId.create("ice_chunk")));
        MAULER = ENTITY_TYPES.register("mauler", () -> EntityType.Builder.of(MaulerEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.5625f, 0.5625f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("mauler")));
        MOOBLOOM = ENTITY_TYPES.register("moobloom", () -> EntityType.Builder.of(MoobloomEntity::new, (MobCategory)MobCategory.CREATURE).sized(0.9f, 1.4f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("moobloom")));
        RASCAL = ENTITY_TYPES.register("rascal", () -> EntityType.Builder.of(RascalEntity::new, (MobCategory)CustomSpawnGroup.getRascalsCategory()).sized(0.9f, 1.25f).clientTrackingRange(10).canSpawnFarFromPlayer().build(VersionedEntityTypeResourceId.create("rascal")));
        TUFF_GOLEM = ENTITY_TYPES.register("tuff_golem", () -> EntityType.Builder.of(TuffGolemEntity::new, (MobCategory)MobCategory.MISC).sized(0.75f, 1.0625f).eyeHeight(0.8f).clientTrackingRange(10).build(VersionedEntityTypeResourceId.create("tuff_golem")));
        WILDFIRE = ENTITY_TYPES.register("wildfire", () -> EntityType.Builder.of(WildfireEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.05f, 2.8125f).clientTrackingRange(10).fireImmune().build(VersionedEntityTypeResourceId.create("wildfire")));
        PLAYER_ILLUSION = ENTITY_TYPES.register("player_illusion", () -> EntityType.Builder.of(PlayerIllusionEntity::new, (MobCategory)MobCategory.MISC).sized(0.7f, 1.875f).clientTrackingRange(10).fireImmune().build(VersionedEntityTypeResourceId.create("player_illusion")));
        SharedConstants.CHECK_DATA_FIXER_SCHEMA = previousUseChoiceTypeRegistrations;
    }
}

