/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.world.gen.feature.tree;

import cn.leolezury.eternalstarlight.common.block.BouldershroomBlock;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.HugeMushroomBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class BouldershroomFeature
extends Feature<NoneFeatureConfiguration> {
    public BouldershroomFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.level();
        BlockPos pos = context.origin();
        RandomSource random = context.random();
        ArrayList<Direction> availableDirs = new ArrayList<Direction>();
        for (Direction direction : Direction.values()) {
            BlockPos attachPos = pos.relative(direction.getOpposite());
            BlockState attachState = level.getBlockState(attachPos);
            if (!attachState.isFaceSturdy((BlockGetter)level, attachPos, direction) || attachState.getBlock() instanceof HugeMushroomBlock) continue;
            availableDirs.add(direction);
        }
        if (availableDirs.isEmpty()) {
            return false;
        }
        return BouldershroomBlock.growMushroom((ServerLevelAccessor)level, random, pos, (Direction)availableDirs.get(random.nextInt(availableDirs.size())));
    }
}

