/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.network;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.util.ESMiscUtil;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record OpenStarlightStoryPacket(Set<ResourceLocation> unlocked) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<OpenStarlightStoryPacket> TYPE = new CustomPacketPayload.Type(EternalStarlight.id("open_starlight_story"));
    public static final StreamCodec<RegistryFriendlyByteBuf, OpenStarlightStoryPacket> STREAM_CODEC = StreamCodec.ofMember(OpenStarlightStoryPacket::write, OpenStarlightStoryPacket::read);

    public static OpenStarlightStoryPacket read(FriendlyByteBuf buf) {
        int size = buf.readInt();
        HashSet<ResourceLocation> unlocked = new HashSet<ResourceLocation>();
        for (int i = 0; i < size; ++i) {
            unlocked.add(ResourceLocation.parse((String)buf.readUtf()));
        }
        return new OpenStarlightStoryPacket(unlocked);
    }

    public static void write(OpenStarlightStoryPacket packet, FriendlyByteBuf buf) {
        buf.writeInt(packet.unlocked().size());
        for (ResourceLocation resourceLocation : packet.unlocked()) {
            buf.writeUtf(resourceLocation.toString());
        }
    }

    public static void handle(OpenStarlightStoryPacket packet, Player player) {
        ESMiscUtil.runWhenOnClient(() -> () -> EternalStarlight.getClientHelper().handleOpenStarlightStory(packet));
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

