/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import java.util.UUID;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin {
    @Shadow
    @Nullable
    private UUID target;
    @Shadow
    private int pickupDelay;
    @Shadow
    private int age;

    @Shadow
    public abstract ItemStack getItem();

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        if (this.age < 3000 && this.getItem().get(DataComponents.FOOD) != null && (itemEntity.level().getBlockState(itemEntity.blockPosition()).is(ESTags.Blocks.TOOTH_OF_HUNGER_BLOCKS) || itemEntity.level().getBlockState(itemEntity.blockPosition().below()).is(ESTags.Blocks.TOOTH_OF_HUNGER_BLOCKS))) {
            this.age = 3000;
        }
    }

    @Inject(method={"playerTouch(Lnet/minecraft/world/entity/player/Player;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void playerTouch(Player player, CallbackInfo ci) {
        ItemEntity itemEntity = (ItemEntity)this;
        if (itemEntity.level().isClientSide) {
            return;
        }
        if (this.pickupDelay == 0 && (this.target == null || this.target.equals(player.getUUID())) && this.getItem().is(ESItems.MANA_CRYSTAL_SHARD.get())) {
            ci.cancel();
            player.take((Entity)itemEntity, this.getItem().getCount());
            itemEntity.discard();
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (!stack.is(ESTags.Items.MANA_CRYSTALS) || !stack.isDamaged()) continue;
                stack.setDamageValue(Math.max(stack.getDamageValue() - this.getItem().getCount(), 0));
                return;
            }
        }
    }
}

