/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.item.combat;

import cn.leolezury.eternalstarlight.common.entity.attack.LunarThorn;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.util.ESEntityUtil;
import cn.leolezury.eternalstarlight.common.vfx.ScreenShakeVfx;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.shapes.CollisionContext;

public class MoonringBowItem
extends BowItem {
    public MoonringBowItem(Item.Properties properties) {
        super(properties);
    }

    public void releaseUsing(ItemStack itemStack, Level level, LivingEntity livingEntity, int n) {
        super.releaseUsing(itemStack, level, livingEntity, n);
        int k = this.getUseDuration(itemStack, livingEntity) - n;
        float powerForTime = MoonringBowItem.getPowerForTime((int)k);
        if (!level.isClientSide && livingEntity instanceof Player && (double)powerForTime == 1.0) {
            float x = -Mth.sin((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float z = Mth.cos((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ScreenShakeVfx.createInstance((ResourceKey<Level>)livingEntity.level().dimension(), livingEntity.position(), 30.0f, 30, 0.15f, 0.24f, 4.0f, 5.0f).send(serverLevel);
            }
            for (int i = 0; i < 16; ++i) {
                this.createThorn(level, livingEntity, livingEntity.getX() + (double)(x * (float)i) * 1.5, livingEntity.getY(), livingEntity.getZ() + (double)(z * (float)i) * 1.5, 40.0, i * 5);
            }
        }
    }

    private void createThorn(Level level, LivingEntity owner, double x, double y, double z, double maxDiff, int delay) {
        BlockPos startPos = BlockPos.containing((double)x, (double)y, (double)z);
        boolean successful = false;
        double finalY = y;
        if (level.getBlockState(startPos).isAir()) {
            ESEntityUtil.RaytraceResult result = ESEntityUtil.raytrace((LevelAccessor)level, CollisionContext.of((Entity)owner), startPos.getCenter(), startPos.getCenter().add(0.0, -maxDiff, 0.0));
            if (result.blockHitResult() != null) {
                finalY = result.blockHitResult().getLocation().y;
                successful = true;
            }
        } else {
            ESEntityUtil.RaytraceResult result;
            int currentDiff = 0;
            while (!level.getBlockState(startPos).isAir() && (double)currentDiff < maxDiff) {
                startPos = startPos.above();
                ++currentDiff;
            }
            if (level.getBlockState(startPos).isAir() && (result = ESEntityUtil.raytrace((LevelAccessor)level, CollisionContext.of((Entity)owner), startPos.getCenter(), startPos.getCenter().add(0.0, -maxDiff, 0.0))).blockHitResult() != null) {
                finalY = result.blockHitResult().getLocation().y;
                successful = true;
            }
        }
        if (successful) {
            LunarThorn thorn = new LunarThorn((EntityType<? extends LunarThorn>)ESEntities.LUNAR_THORN.get(), level);
            thorn.setPos(x, finalY, z);
            thorn.setOwner(owner);
            thorn.setSpawnedTicks(-delay);
            level.addFreshEntity((Entity)thorn);
        }
    }
}

