/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.animal;

import cn.leolezury.eternalstarlight.common.entity.living.animal.Yeti;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSensorTypes;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.AnimalMakeLove;
import net.minecraft.world.entity.ai.behavior.AnimalPanic;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.CountDownCooldownTicks;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.FollowTemptation;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.crafting.Ingredient;

public class YetiAi {
    public static final List<SensorType<? extends Sensor<? super Yeti>>> SENSOR_TYPES = ImmutableList.of((Object)SensorType.NEAREST_LIVING_ENTITIES, (Object)SensorType.HURT_BY, (Object)SensorType.NEAREST_PLAYERS, ESSensorTypes.YETI_TEMPTATIONS.get());
    public static final List<MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryModuleType.WALK_TARGET, (Object)MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, (Object)MemoryModuleType.PATH, (Object)MemoryModuleType.IS_PANICKING, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryModuleType.BREED_TARGET, (Object)MemoryModuleType.TEMPTING_PLAYER, (Object)MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, (Object)MemoryModuleType.IS_TEMPTED);

    public static Ingredient getTemptations() {
        return Ingredient.of(ESTags.Items.YETI_FOOD);
    }

    protected static Brain<?> makeBrain(Brain<Yeti> brain) {
        YetiAi.initCoreActivity(brain);
        YetiAi.initIdleActivity(brain);
        brain.setCoreActivities(Set.of(Activity.CORE));
        brain.setDefaultActivity(Activity.IDLE);
        brain.useDefaultActivity();
        return brain;
    }

    private static void initCoreActivity(Brain<Yeti> brain) {
        brain.addActivity(Activity.CORE, 0, ImmutableList.of((Object)new Swim(0.8f), (Object)new AnimalPanic(1.0f), (Object)new MoveToTargetSink(), (Object)new CountDownCooldownTicks(MemoryModuleType.TEMPTATION_COOLDOWN_TICKS)));
    }

    private static void initIdleActivity(Brain<Yeti> brain) {
        brain.addActivity(Activity.IDLE, ImmutableList.of((Object)Pair.of((Object)0, (Object)new AnimalMakeLove(ESEntities.YETI.get())), (Object)Pair.of((Object)1, (Object)new FollowTemptation(livingEntity -> Float.valueOf(1.25f), livingEntity -> 3.5)), (Object)Pair.of((Object)2, (Object)new LookAtTargetSink(45, 90)), (Object)Pair.of((Object)3, (Object)((Object)new StartRolling())), (Object)Pair.of((Object)3, (Object)((Object)new StopRolling())), (Object)Pair.of((Object)3, (Object)new RunOne((List)ImmutableList.of((Object)Pair.of((Object)SetWalkTargetFromLookTarget.create((float)1.0f, (int)3), (Object)2), (Object)Pair.of((Object)SetEntityLookTarget.create((EntityType)EntityType.PLAYER, (float)6.0f), (Object)1), (Object)Pair.of((Object)RandomStroll.stroll((float)1.0f), (Object)1), (Object)Pair.of((Object)new DoNothing(5, 20), (Object)2))))));
    }

    static void updateActivity(Yeti yeti) {
        yeti.getBrain().setActiveActivityToFirstValid((List)ImmutableList.of((Object)Activity.IDLE));
    }

    private static class StartRolling
    extends Behavior<Yeti> {
        private StartRolling() {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT), 10);
        }

        protected boolean checkExtraStartConditions(ServerLevel serverLevel, Yeti yeti) {
            return yeti.getRollState() == 0 && !yeti.getMoveControl().hasWanted() && yeti.getRollCooldown() <= 0 && yeti.getRandom().nextInt(10) == 0;
        }

        protected boolean canStillUse(ServerLevel serverLevel, Yeti livingEntity, long l) {
            return true;
        }

        protected void start(ServerLevel serverLevel, Yeti yeti, long l) {
            yeti.setRollState(1);
            yeti.setRollTicks(400);
        }

        protected void stop(ServerLevel serverLevel, Yeti yeti, long l) {
            yeti.setRollState(2);
        }
    }

    private static class StopRolling
    extends Behavior<Yeti> {
        private StopRolling() {
            super(Map.of(MemoryModuleType.WALK_TARGET, MemoryStatus.VALUE_ABSENT, MemoryModuleType.IS_PANICKING, MemoryStatus.VALUE_ABSENT), 10);
        }

        protected boolean checkExtraStartConditions(ServerLevel serverLevel, Yeti yeti) {
            return yeti.getRollState() == 2 && !yeti.getMoveControl().hasWanted() && yeti.getRollTicks() == 0;
        }

        protected boolean canStillUse(ServerLevel serverLevel, Yeti livingEntity, long l) {
            return true;
        }

        protected void start(ServerLevel serverLevel, Yeti yeti, long l) {
            yeti.setRollState(3);
        }

        protected void stop(ServerLevel serverLevel, Yeti yeti, long l) {
            yeti.setRollState(0);
            yeti.setRollTicks(400);
            yeti.setRollCooldown(600);
        }
    }
}

