/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.particle.effect;

import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.util.Easing;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ExplosionShockParticle
extends TextureSheetParticle {
    private final Vec3 direction;
    private final float length;
    private final Vector3f fromColor;
    private final Vector3f toColor;

    protected ExplosionShockParticle(ClientLevel clientLevel, double x, double y, double z, double dx, double dy, double dz, Vector3f fromColor, Vector3f toColor, SpriteSet spriteSet) {
        super(clientLevel, x, y, z, dx, dy, dz);
        this.friction = 0.0f;
        this.lifetime = (int)(this.random.nextFloat() * 7.0f + 7.0f);
        this.direction = new Vec3(dx, dy, dz).normalize();
        this.length = this.random.nextFloat() * 1.25f + 1.15f;
        this.fromColor = fromColor;
        this.toColor = toColor;
        this.pickSprite(spriteSet);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public void render(VertexConsumer consumer, Camera camera, float partialTick) {
        Vec3 camPos = camera.getPosition();
        PoseStack stack = new PoseStack();
        stack.pushPose();
        stack.translate(-camPos.x, -camPos.y, -camPos.z);
        double currentX = Mth.lerp((double)partialTick, (double)this.xo, (double)this.x);
        double currentY = Mth.lerp((double)partialTick, (double)this.yo, (double)this.y);
        double currentZ = Mth.lerp((double)partialTick, (double)this.zo, (double)this.z);
        Vec3 sight = camPos.subtract(currentX, currentY, currentZ).scale(-1.0);
        Vec3 start = new Vec3(currentX, currentY, currentZ).add(this.direction.scale((double)Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, 0.0f, this.length * 2.0f)));
        Vec3 end = start.add(this.direction.scale((double)Easing.IN_OUT_QUAD.interpolate(Mth.abs((float)(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime - 0.5f)) * 2.0f, this.length / 2.0f, 0.0f)));
        Vec3 offset = end.subtract(start);
        Vec3 sideOffset = offset.cross(sight).normalize().scale(0.03);
        PoseStack.Pose pose = stack.last();
        float u0 = this.getU0();
        float u1 = Easing.IN_OUT_QUAD.interpolate(Mth.abs((float)(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime - 0.5f)) * 2.0f, this.getU1(), this.getU0());
        float v0 = this.getV0();
        float v1 = this.getV1();
        consumer.addVertex(pose, start.add(sideOffset).toVector3f()).setColor(Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.x(), this.toColor.x()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.y(), this.toColor.y()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.z(), this.toColor.z()) / 255.0f, 1.0f).setUv(u0, v0).setLight(0xF000F0);
        consumer.addVertex(pose, start.add(sideOffset.scale(-1.0)).toVector3f()).setColor(Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.x(), this.toColor.x()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.y(), this.toColor.y()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.z(), this.toColor.z()) / 255.0f, 1.0f).setUv(u0, v1).setLight(0xF000F0);
        consumer.addVertex(pose, end.add(sideOffset.scale(-1.0)).toVector3f()).setColor(Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.x(), this.toColor.x()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.y(), this.toColor.y()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.z(), this.toColor.z()) / 255.0f, 1.0f).setUv(u1, v1).setLight(0xF000F0);
        consumer.addVertex(pose, end.add(sideOffset).toVector3f()).setColor(Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.x(), this.toColor.x()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.y(), this.toColor.y()) / 255.0f, Easing.IN_OUT_QUAD.interpolate(Math.min((float)this.age + partialTick, (float)this.lifetime) / (float)this.lifetime, this.fromColor.z(), this.toColor.z()) / 255.0f, 1.0f).setUv(u1, v0).setLight(0xF000F0);
        stack.popPose();
    }

    public static class Provider
    implements ParticleProvider<ExplosionShockParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet spriteSet) {
            this.sprites = spriteSet;
        }

        public Particle createParticle(ExplosionShockParticleOptions options, ClientLevel level, double x, double y, double z, double dx, double dy, double dz) {
            return new ExplosionShockParticle(level, x, y, z, dx, dy, dz, options.fromColor(), options.toColor(), this.sprites);
        }
    }
}

