/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.entity;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedEntityModel;
import cn.leolezury.eternalstarlight.common.client.model.animation.definition.FreezeAnimation;
import cn.leolezury.eternalstarlight.common.entity.living.monster.Freeze;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FreezeModel<T extends Freeze>
extends AnimatedEntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(EternalStarlight.id("freeze"), "main");
    private final ModelPart root;
    private final ModelPart head;

    public FreezeModel(ModelPart root) {
        this.root = root;
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(16, 16).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 1.0f, 4.0f, new CubeDeformation(0.0f)).texOffs(32, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition rods = partdefinition.addOrReplaceChild("rods", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)15.0f, (float)0.0f));
        rods.addOrReplaceChild("rod1", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)-6.0f, (float)-0.5672f, (float)0.0f, (float)0.0f));
        rods.addOrReplaceChild("rod2", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)-6.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.5672f));
        rods.addOrReplaceChild("rod3", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)6.0f, (float)-0.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.5672f));
        rods.addOrReplaceChild("rod4", CubeListBuilder.create().texOffs(0, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(8, 16).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)6.0f, (float)0.5672f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root().getAllParts().forEach(ModelPart::resetPose);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.animate(((Freeze)((Object)entity)).idleAnimationState, FreezeAnimation.IDLE, ageInTicks);
        if (entity.isAggressive()) {
            this.animate(((Freeze)((Object)entity)).idleAnimationState, FreezeAnimation.IDLE_AGGRESSIVE, ageInTicks);
        }
        if (((Freeze)((Object)entity)).isAttacking()) {
            this.animate(((Freeze)((Object)entity)).throwAnimationState, FreezeAnimation.THROW, ageInTicks);
        }
    }

    public RenderType renderType(ResourceLocation resourceLocation) {
        return RenderType.entityTranslucent((ResourceLocation)resourceLocation);
    }

    @Override
    public ModelPart root() {
        return this.root;
    }
}

