/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.model.animation;

import cn.leolezury.eternalstarlight.common.client.model.animation.AnimatedModel;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class ESKeyframeAnimations {
    public static void animate(AnimatedModel model, AnimationDefinition definition, long accumulatedTime, float scale, Vector3f cache) {
        float f = ESKeyframeAnimations.getElapsedSeconds(definition, accumulatedTime);
        for (Map.Entry entry : definition.boneAnimations().entrySet()) {
            Optional<ModelPart> optional = model.getAnyDescendantWithName((String)entry.getKey());
            List list = (List)entry.getValue();
            optional.ifPresent(modelPart -> list.forEach(animationChannel -> {
                Keyframe[] akeyframe = animationChannel.keyframes();
                int i = Math.max(0, Mth.binarySearch((int)0, (int)akeyframe.length, i1 -> f <= akeyframe[i1].timestamp()) - 1);
                int j = Math.min(akeyframe.length - 1, i + 1);
                Keyframe keyframe = akeyframe[i];
                Keyframe keyframe1 = akeyframe[j];
                float f1 = f - keyframe.timestamp();
                float f2 = Mth.clamp((float)(f1 / (keyframe1.timestamp() - keyframe.timestamp())), (float)0.0f, (float)1.0f);
                keyframe1.interpolation().apply(cache, f2, akeyframe, i, j, scale);
                animationChannel.target().apply(modelPart, cache);
            }));
        }
    }

    private static float getElapsedSeconds(AnimationDefinition definition, long accumulatedTime) {
        float f = (float)accumulatedTime / 1000.0f;
        return definition.looping() ? f % definition.lengthInSeconds() : f;
    }
}

