/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block.entity;

import cn.leolezury.eternalstarlight.common.registry.ESBlockEntities;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TorreyaCampfireBlockEntity
extends CampfireBlockEntity {
    public TorreyaCampfireBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(blockPos, blockState);
    }

    public boolean isValidBlockState(BlockState blockState) {
        return this.getType().isValid(blockState);
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, CampfireBlockEntity campfireBlockEntity) {
        if (((Boolean)blockState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            TorreyaCampfireBlockEntity.cookTick((Level)level, (BlockPos)blockPos, (BlockState)blockState, (CampfireBlockEntity)campfireBlockEntity);
            AABB box = AABB.unitCubeFromLowerCorner((Vec3)Vec3.atLowerCornerOf((Vec3i)blockPos)).inflate(10.0);
            for (LivingEntity living : level.getEntitiesOfClass(LivingEntity.class, box)) {
                if (living instanceof Enemy || living.hasEffect(MobEffects.REGENERATION)) continue;
                living.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 100));
            }
            for (LivingEntity living : level.getEntitiesOfClass(LivingEntity.class, box)) {
                if (!(living instanceof Enemy) || living.hasEffect(ESMobEffects.STARFIRE.asHolder())) continue;
                living.addEffect(new MobEffectInstance(ESMobEffects.STARFIRE.asHolder(), 100));
            }
        } else {
            TorreyaCampfireBlockEntity.cooldownTick((Level)level, (BlockPos)blockPos, (BlockState)blockState, (CampfireBlockEntity)campfireBlockEntity);
        }
    }

    public BlockEntityType<?> getType() {
        return ESBlockEntities.TORREYA_CAMPFIRE.get();
    }
}

