/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.block;

import cn.leolezury.eternalstarlight.common.block.StarfireBirdNestBlock;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class StarfireBirdAviaryBlock
extends StarfireBirdNestBlock {
    public static final MapCodec<StarfireBirdAviaryBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockSetType.CODEC.fieldOf("block_set_type").forGetter(block -> block.type), (App)StarfireBirdAviaryBlock.propertiesCodec()).apply((Applicative)instance, StarfireBirdAviaryBlock::new));
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.75, (double)16.0);
    public static final BooleanProperty OPEN = BlockStateProperties.OPEN;
    private final BlockSetType type;

    public StarfireBirdAviaryBlock(BlockSetType type, BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OPEN, (Comparable)Boolean.valueOf(false)));
        this.type = type;
    }

    protected MapCodec<StarfireBirdAviaryBlock> codec() {
        return CODEC;
    }

    @Override
    public float getSeedsRenderOffset() {
        return 0.1875f;
    }

    @Override
    protected VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide) {
            boolean open = (Boolean)state.getValue((Property)OPEN);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OPEN, (Comparable)Boolean.valueOf(!open)));
            level.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY(), (double)pos.getZ() + 0.5, open ? this.type.trapdoorClose() : this.type.trapdoorOpen(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Override
    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return true;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{OPEN});
        super.createBlockStateDefinition(builder);
    }
}

