/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.network;

import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.Helpers;
import shetiphian.core.platform.Services;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;
import shetiphian.multibeds.network.PacketEmbroidery;
import shetiphian.multibeds.network.PacketShareTag;

final class ServerPayloadHandler {
    static final ServerPayloadHandler INSTANCE = new ServerPayloadHandler();

    ServerPayloadHandler() {
    }

    void handle(PacketEmbroidery packet, Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TileEntityMultiBed[] tiles = BlockMultiBed.getTiles((BlockGetter)player.level(), packet.pos());
            if (tiles != null) {
                boolean isMirrored;
                ItemStack blanket = tiles[0].hasBlanket() ? tiles[0].getBlanketItem().copy() : tiles[1].getBlanketItem().copy();
                boolean bl = isMirrored = tiles[0].hasBlanket() ? tiles[0].isMirrored() : tiles[1].isMirrored();
                if (!blanket.isEmpty()) {
                    ItemEmbroideryThread.setArtwork(blanket, packet.art(), packet.embroidery());
                    if (tiles[0].setBlanketItem(blanket, isMirrored)) {
                        tiles[1].setBlanketItem(tiles[0].getBlanketItem(), tiles[0].isMirrored());
                    }
                    Helpers.syncTile((BlockEntity)tiles[0]);
                    Helpers.syncTile((BlockEntity)tiles[1]);
                    if (packet.art() != EnumSpreadArt.NONE) {
                        serverPlayer.getInventory().getSelected().hurtAndBreak(1, (ServerLevel)serverPlayer.level(), serverPlayer, entity -> {});
                    }
                }
            }
        }
    }

    void handle(PacketShareTag packet, Player player) {
        if (packet.toAll()) {
            Services.NETWORK.sendToAll((CustomPacketPayload)new PacketShareTag(packet.name(), packet.embroidery(), false));
        } else if (player instanceof ServerPlayer) {
            Services.NETWORK.sendToAllAround((CustomPacketPayload)new PacketShareTag(packet.name(), packet.embroidery(), false), (Entity)player, 128.0);
        }
    }
}

