/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.modintegration.jade;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.misc.TextureInfoHelper;
import shetiphian.multibeds.common.block.BlockBedExtra;
import shetiphian.multibeds.common.block.BlockBunkLadder;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.tileentity.TileEntityBedExtra;
import shetiphian.multibeds.common.tileentity.TileEntityLadder;
import shetiphian.multibeds.common.tileentity.TileEntityMultiBed;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;

@WailaPlugin
public final class JadePlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        Block[] allBeds;
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, BlockBedExtra.class);
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, BlockMultiBed.class);
        registration.registerBlockComponent((IComponentProvider)ComponentProvider.INSTANCE, BlockBunkLadder.class);
        for (Block bed : allBeds = new Block[]{(Block)Roster.Blocks.CUSTOM.get(), (Block)Roster.Blocks.SLAB.get(), (Block)Roster.Blocks.COT.get(), (Block)Roster.Blocks.CLASSIC.get(), (Block)Roster.Blocks.VINTAGE.get(), (Block)Roster.Blocks.MODERN.get(), (Block)Roster.Blocks.RUSTIC.get()}) {
            registration.usePickedResult(bed);
        }
        registration.usePickedResult((Block)Roster.Blocks.BEXTRA.get());
    }

    private static class ComponentProvider
    implements IBlockComponentProvider {
        private static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = MultiBeds.RESOURCE.apply("hud");

        private ComponentProvider() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            BlockEntity tile = accessor.getBlockEntity();
            if (tile instanceof TileEntityBedExtra) {
                tile = accessor.getLevel().getBlockEntity(accessor.getPosition().below());
            }
            if (tile instanceof TileEntityMultiBed) {
                TileEntityMultiBed bed = (TileEntityMultiBed)tile;
                LocalPlayer player = Minecraft.getInstance().player;
                tooltip.addAll(TextureInfoHelper.getHUD(bed, player == null || !player.isShiftKeyDown()));
            }
            if (tile instanceof TileEntityLadder) {
                TileEntityLadder ladder = (TileEntityLadder)tile;
                tooltip.addAll(TextureInfoHelper.getHUD(ladder));
            }
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

