/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.worldgen;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.block.BlockMultiBed;

public class BedSwapper {
    private static final Map<DyeColor, CompoundTag> BED_TAGS = new HashMap<DyeColor, CompoundTag>();

    public static StructureTemplate.StructureBlockInfo swap(StructureTemplate.StructureBlockInfo original) {
        BedPart part = (BedPart)original.state().getValue((Property)BedBlock.PART);
        Direction facing = (Direction)original.state().getValue((Property)BedBlock.FACING);
        BlockState multibed = (BlockState)((BlockState)((BlockState)((BlockMultiBed)Roster.Blocks.RUSTIC.get()).defaultBlockState().setValue((Property)BlockMultiBed.FACING, (Comparable)facing)).setValue((Property)BlockMultiBed.PART, (Comparable)part)).setValue((Property)BlockMultiBed.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        return new StructureTemplate.StructureBlockInfo(original.pos(), multibed, BedSwapper.getTag(original.state().getBlock()));
    }

    private static CompoundTag getTag(Block block) {
        DyeColor color;
        if (block instanceof BedBlock) {
            BedBlock bedBlock = (BedBlock)block;
            v0 = bedBlock.getColor();
        } else {
            v0 = color = DyeColor.RED;
        }
        if (!BED_TAGS.containsKey(color)) {
            CompoundTag tag = BedSwapper.tagBuilder(color);
            BED_TAGS.put(color, tag);
        }
        return BED_TAGS.get(color);
    }

    private static CompoundTag tagBuilder(DyeColor color) {
        CompoundTag tagRoot = new CompoundTag();
        CompoundTag tagComponents = new CompoundTag();
        CompoundTag tagBedding = new CompoundTag();
        CompoundTag tagBlanket = new CompoundTag();
        tagBlanket.putString("id", "multibeds:blanket_" + color.getSerializedName());
        tagBlanket.putInt("count", 1);
        tagBedding.put("blanket", (Tag)tagBlanket);
        CompoundTag tagPillow = new CompoundTag();
        tagPillow.putString("id", "multibeds:pillow");
        tagPillow.putInt("count", 1);
        tagBedding.put("pillow", (Tag)tagPillow);
        CompoundTag tagSheet = new CompoundTag();
        tagSheet.putString("id", "multibeds:sheet");
        tagSheet.putInt("count", 1);
        tagBedding.put("sheet", (Tag)tagSheet);
        tagComponents.put("multibeds:bedding", (Tag)tagBedding);
        tagRoot.put("components", (Tag)tagComponents);
        return tagRoot;
    }

    public static boolean isBed(Block block) {
        return block instanceof BedBlock && (block == Blocks.BLACK_BED || block == Blocks.BLUE_BED || block == Blocks.BROWN_BED || block == Blocks.CYAN_BED || block == Blocks.GRAY_BED || block == Blocks.GREEN_BED || block == Blocks.LIGHT_BLUE_BED || block == Blocks.LIGHT_GRAY_BED || block == Blocks.LIME_BED || block == Blocks.MAGENTA_BED || block == Blocks.ORANGE_BED || block == Blocks.PINK_BED || block == Blocks.PURPLE_BED || block == Blocks.RED_BED || block == Blocks.WHITE_BED || block == Blocks.YELLOW_BED);
    }
}

