/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.apache.commons.lang3.tuple.Triple;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.model.ModelProperties;
import shetiphian.multibeds.common.block.BlockMultiBed;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.item.ItemPillowSheet;
import shetiphian.multibeds.common.misc.BiomeTexture;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumBedStyle;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class TileEntityMultiBed
extends TileEntityBase {
    private static final RGB16 RGB_WHITE = new RGB16("white");
    private Texture texture = Texture.EMPTY;
    private ItemStack itemSheet = ItemStack.EMPTY;
    private ItemStack itemPillow = ItemStack.EMPTY;
    private ItemStack itemBlanket = ItemStack.EMPTY;
    private boolean mirrored = false;
    private int sheetColor = RGB_WHITE.getColor();
    private int pillowColor = RGB_WHITE.getColor();
    private EnumBlanket spreadBlanket = EnumBlanket.NONE;
    private EnumSpreadArt spreadArt = EnumSpreadArt.NONE;
    private BannerBlockEntity bannerEntity = null;
    private Triple<String, Byte, byte[]> artData = null;
    private boolean isColorCached = false;
    private int materialColor = 0xFFFFFF;
    private boolean needsDefaultTexture = false;

    public TileEntityMultiBed(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.BED.get(), pos, state);
    }

    public void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (!this.texture.stack().isEmpty()) {
            nbtTag.put("texture_item", this.texture.stack().save(provider));
        }
        if (!this.itemSheet.isEmpty()) {
            nbtTag.put("sheet_item", this.itemSheet.save(provider));
        }
        if (!this.itemPillow.isEmpty()) {
            nbtTag.put("pillow_item", this.itemPillow.save(provider));
        }
        if (!this.itemBlanket.isEmpty()) {
            nbtTag.put("blanket_item", this.itemBlanket.save(provider));
            nbtTag.putBoolean("mirror", this.mirrored);
        }
    }

    public void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (nbtTag.contains("texture_item")) {
            this.texture = new Texture(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("texture_item")));
        } else if (this.level != null) {
            this.applyDefaultTexture();
        } else {
            this.needsDefaultTexture = true;
        }
        if (nbtTag.contains("sheet_item")) {
            this.setSheetItem(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("sheet_item")));
        } else {
            this.removeSheet();
        }
        if (nbtTag.contains("pillow_item")) {
            this.setPillowItem(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("pillow_item")));
        } else {
            this.removePillow();
        }
        if (nbtTag.contains("blanket_item")) {
            this.setBlanketItem(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("blanket_item")), nbtTag.getBoolean("mirror"));
        } else {
            this.removeBlanket();
        }
        this.flagModelRenderDataForUpdate();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)this.texture);
        if (!(this.itemSheet.isEmpty() && this.itemPillow.isEmpty() && this.itemBlanket.isEmpty())) {
            components.set((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)new Bedding(this.itemBlanket, this.itemPillow, this.itemSheet, this.mirrored));
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.texture = (Texture)components.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.EMPTY);
        Bedding bedding = (Bedding)components.get((DataComponentType)Roster.Components.BEDDING_DATA.get());
        if (bedding != null) {
            this.itemBlanket = bedding.blanket();
            this.itemPillow = bedding.pillow();
            this.itemSheet = bedding.sheet();
            this.mirrored = bedding.mirrored();
        }
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (this.needsDefaultTexture) {
            this.applyDefaultTexture();
        }
    }

    private void applyDefaultTexture() {
        if (this.texture.stack().isEmpty() && this.level != null) {
            ItemStack stack = BiomeTexture.getStackFor((Holder<Biome>)this.level.getBiome(this.worldPosition));
            this.texture = stack.isEmpty() ? Texture.EMPTY : new Texture(stack);
        }
    }

    public ItemStack getTextureBlock() {
        return this.texture.stack();
    }

    public boolean isBedFoot() {
        return this.getBlockState().getValue((Property)BedBlock.PART) == BedPart.FOOT;
    }

    public Direction getFacing() {
        return (Direction)this.getBlockState().getValue((Property)BlockMultiBed.FACING);
    }

    public boolean hasSheet() {
        return !this.itemSheet.isEmpty();
    }

    public void removeSheet() {
        this.itemSheet = ItemStack.EMPTY;
        this.sheetColor = RGB_WHITE.getColor();
    }

    public boolean setSheetItem(ItemStack stack) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ItemPillowSheet && ((ItemPillowSheet)item).getType() == ItemBedCustomization.EnumType.SHEET) {
            this.itemSheet = stack.copy().split(1);
            this.sheetColor = ((ItemPillowSheet)item).getRenderColor(stack);
            return true;
        }
        return false;
    }

    public ItemStack getSheetItem() {
        return this.itemSheet;
    }

    public int getSheetColor() {
        return this.sheetColor;
    }

    public boolean hasPillow() {
        return !this.itemPillow.isEmpty();
    }

    public void removePillow() {
        this.itemPillow = ItemStack.EMPTY;
        this.pillowColor = RGB_WHITE.getColor();
    }

    public boolean setPillowItem(ItemStack stack) {
        Item item;
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof ItemPillowSheet && ((ItemPillowSheet)item).getType() == ItemBedCustomization.EnumType.PILLOW) {
            this.itemPillow = stack.copy().split(1);
            this.pillowColor = ((ItemPillowSheet)item).getRenderColor(stack);
            return true;
        }
        return false;
    }

    public ItemStack getPillowItem() {
        return this.itemPillow;
    }

    public int getPillowColor() {
        return this.pillowColor;
    }

    public boolean hasBlanket() {
        return !this.itemBlanket.isEmpty();
    }

    public void removeBlanket() {
        this.itemBlanket = ItemStack.EMPTY;
        this.spreadBlanket = EnumBlanket.NONE;
        this.bannerEntity = null;
        this.removeArt();
    }

    public EnumBlanket getBlanketType() {
        return this.spreadBlanket;
    }

    public boolean setBlanketItem(ItemStack stack, boolean mirror) {
        if (!stack.isEmpty()) {
            Item item = stack.getItem();
            if (item instanceof BannerItem) {
                this.setArt(stack);
                this.itemBlanket = stack.copy().split(1);
                this.spreadBlanket = EnumBlanket.BANNER;
                this.mirrored = mirror;
                SideExecutor.runOnClient(() -> () -> {
                    this.bannerEntity = null;
                    this.bannerEntity = new BannerBlockEntity(this.worldPosition, ((BannerItem)item).getBlock().defaultBlockState());
                    this.bannerEntity.fromItem(stack, ((BannerItem)stack.getItem()).getColor());
                });
                return true;
            }
            if (item instanceof ItemBlanket) {
                this.setArt(stack);
                this.itemBlanket = stack.copy().split(1);
                this.spreadBlanket = ItemBlanket.getBlanket(stack);
                this.bannerEntity = null;
                return true;
            }
        }
        return false;
    }

    public ItemStack getBlanketItem() {
        return this.itemBlanket;
    }

    public boolean isMirrored() {
        return this.mirrored;
    }

    public boolean hasArt() {
        return this.getArtType() != EnumSpreadArt.NONE;
    }

    private void removeArt() {
        this.artData = null;
        this.spreadArt = EnumSpreadArt.NONE;
    }

    private void setArt(ItemStack stack) {
        if (!stack.isEmpty()) {
            Embroidery embroidery;
            this.removeArt();
            this.spreadArt = ItemEmbroideryThread.getArtwork(stack);
            if (this.getArtType() == EnumSpreadArt.CUSTOM && (embroidery = ItemEmbroideryThread.getArtworkEmbroidery(stack)) != null) {
                String artTextureKey = "embroidery." + Integer.toHexString(embroidery.hashCode());
                this.artData = Triple.of((Object)artTextureKey, (Object)embroidery.palette(), (Object)embroidery.getUncompressedIndices());
            }
        }
    }

    public EnumSpreadArt getArtType() {
        return this.spreadArt;
    }

    public BannerBlockEntity getBannerEntity() {
        return this.bannerEntity;
    }

    public Triple<String, Byte, byte[]> getArtData() {
        return this.artData;
    }

    public int getMaterialColor() {
        SideExecutor.runOnClient(() -> () -> {
            if (!this.isColorCached && this.level != null) {
                this.materialColor = Minecraft.getInstance().getBlockColors().getColor(UseContext.getBlockPlacementStateFor((ItemStack)this.getTextureBlock(), (Level)this.level), (BlockAndTintGetter)this.level, this.worldPosition, 0);
                this.isColorCached = true;
            }
        });
        return this.materialColor;
    }

    public RenderData getModelRenderData() {
        BlockEntity tile;
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.putString("bed_type", this.getModelType());
        nbtTag.putBoolean("has_sheet", this.hasSheet());
        nbtTag.putBoolean("has_pillowcase", this.hasPillow());
        nbtTag.putString("blanket_type", this.getBlanketType().getSerializedName());
        nbtTag.putString("art_type", this.getArtType().getSerializedName());
        if (this.level != null && ((BlockMultiBed)this.getBlockState().getBlock()).getBedStyle().hasTopper() && (tile = this.level.getBlockEntity(this.worldPosition.above())) instanceof TileEntityBase) {
            TileEntityBase tileEntityBase = (TileEntityBase)tile;
            tileEntityBase.flagModelRenderDataForUpdate();
        }
        RenderData.Builder builder = RenderData.builder().with(ModelProperties.NBT, (Object)nbtTag);
        ItemStack bedTextureBlock = this.getTextureBlock();
        if (!bedTextureBlock.isEmpty()) {
            builder.with(ModelProperties.TEXTURE, (Object)bedTextureBlock);
        }
        return builder.build();
    }

    public String getModelType() {
        BlockState state = this.getBlockState();
        EnumBedStyle style = ((BlockMultiBed)state.getBlock()).getBedStyle();
        String typeBunk = "single";
        String typeGang = "single";
        if (this.level != null) {
            if (style.isBunkable()) {
                boolean down = this.isSame(state, this.level.getBlockState(this.worldPosition.below()), style);
                boolean up = this.isSame(state, this.level.getBlockState(this.worldPosition.above()), style);
                String string = down && up ? "middle" : (down ? "top" : (typeBunk = up ? "bottom" : "single"));
            }
            if (style.isGangable()) {
                Direction facing = (Direction)state.getValue((Property)BlockMultiBed.FACING);
                boolean left = this.isSame(state, this.level.getBlockState(this.worldPosition.relative(facing.getCounterClockWise())), style);
                boolean right = this.isSame(state, this.level.getBlockState(this.worldPosition.relative(facing.getClockWise())), style);
                typeGang = left && right ? "middle" : (left ? "right" : (right ? "left" : "single"));
            }
        }
        return typeBunk + "#" + typeGang;
    }

    private boolean isSame(BlockState state, BlockState oState, EnumBedStyle style) {
        Block oBlock = oState.getBlock();
        return oBlock instanceof BlockMultiBed && ((BedPart)oState.getValue((Property)BlockMultiBed.PART)).equals((Object)state.getValue((Property)BlockMultiBed.PART)) && ((Direction)oState.getValue((Property)BlockMultiBed.FACING)).equals((Object)state.getValue((Property)BlockMultiBed.FACING)) && ((BlockMultiBed)oBlock).getBedStyle() == style;
    }
}

