/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.model.data.RenderData;
import shetiphian.core.common.UseContext;
import shetiphian.core.common.tileentity.TileEntityBase;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.client.model.ModelProperties;
import shetiphian.multibeds.common.block.BlockBunkLadder;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.misc.BiomeTexture;

public class TileEntityLadder
extends TileEntityBase {
    private Texture texture = Texture.EMPTY;
    private boolean isColorCached = false;
    private int materialColor = 0xFFFFFF;
    private boolean needsDefaultTexture = false;

    public TileEntityLadder(BlockPos pos, BlockState state) {
        super((BlockEntityType)Roster.Tiles.LADDER.get(), pos, state);
    }

    public void buildNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (!this.texture.stack().isEmpty()) {
            nbtTag.put("texture_item", this.texture.stack().save(provider));
        }
    }

    public void processNBT(CompoundTag nbtTag, HolderLookup.Provider provider) {
        if (nbtTag.contains("texture_item")) {
            this.texture = new Texture(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)nbtTag.getCompound("texture_item")));
        } else if (this.level != null) {
            this.applyDefaultTexture();
        } else {
            this.needsDefaultTexture = true;
        }
        this.flagModelRenderDataForUpdate();
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        components.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)this.texture);
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput components) {
        super.applyImplicitComponents(components);
        this.texture = (Texture)components.getOrDefault((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)Texture.EMPTY);
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (this.needsDefaultTexture) {
            this.applyDefaultTexture();
        }
    }

    private void applyDefaultTexture() {
        if (this.texture.stack().isEmpty() && this.level != null) {
            ItemStack stack = BiomeTexture.getStackFor((Holder<Biome>)this.level.getBiome(this.worldPosition));
            this.texture = stack.isEmpty() ? Texture.EMPTY : new Texture(stack);
        }
    }

    public ItemStack getTextureBlock() {
        return this.texture.stack();
    }

    public int getMaterialColor() {
        SideExecutor.runOnClient(() -> () -> {
            if (!this.isColorCached && this.level != null) {
                this.materialColor = Minecraft.getInstance().getBlockColors().getColor(UseContext.getBlockPlacementStateFor((ItemStack)this.getTextureBlock(), (Level)this.level), (BlockAndTintGetter)this.level, this.worldPosition, 0);
                this.isColorCached = true;
            }
        });
        return this.materialColor;
    }

    @NotNull
    public RenderData getModelRenderData() {
        CompoundTag nbtTag = new CompoundTag();
        nbtTag.putString("ladder_type", this.getModelType());
        RenderData.Builder builder = RenderData.builder().with(ModelProperties.NBT, (Object)nbtTag);
        ItemStack ladderTextureBlock = this.getTextureBlock();
        if (!ladderTextureBlock.isEmpty()) {
            builder.with(ModelProperties.TEXTURE, (Object)ladderTextureBlock);
        }
        return builder.build();
    }

    public String getModelType() {
        Direction direction = (Direction)this.getBlockState().getValue((Property)BlockBunkLadder.FACING);
        if (this.level != null) {
            boolean up = this.isSame(direction, this.level.getBlockState(this.worldPosition.above()));
            boolean down = this.isSame(direction, this.level.getBlockState(this.worldPosition.below()));
            return up ? (down ? "middle" : "bottom") : (down ? "top" : "single");
        }
        return "single";
    }

    private boolean isSame(Direction direction, BlockState oState) {
        Block oBlock = oState.getBlock();
        return oBlock instanceof BlockBunkLadder && ((Direction)oState.getValue((Property)BlockBunkLadder.FACING)).equals((Object)direction);
    }
}

