/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.block.Block;
import shetiphian.multibeds.common.block.BlockMultiBed;

public enum EnumBedStyle implements StringRepresentable
{
    CUSTOM("custom", true, false, BaseType.SLAT),
    SLAB("slab", true, false, BaseType.NONE),
    COT("cot", true, true, BaseType.SLAT),
    CLASSIC("classic", true, true, BaseType.SLAT),
    VINTAGE("vintage", true, true, BaseType.SLAT),
    MODERN("modern", true, true, BaseType.SLAT),
    RUSTIC("rustic", true, true, BaseType.SLAT),
    FUTURE("future", true, true, BaseType.NONE),
    CREW("crew", true, true, BaseType.NONE);

    public static final StringRepresentable.EnumCodec<EnumBedStyle> CODEC;
    private final String name;
    private final boolean bunkable;
    private final boolean gangable;
    private final BaseType baseType;

    private EnumBedStyle(String name, boolean gangable, boolean bunkable, BaseType base) {
        this.name = name;
        this.gangable = gangable;
        this.bunkable = bunkable;
        this.baseType = base;
    }

    private String getString() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public String getSerializedName() {
        return this.name;
    }

    public boolean isGangable() {
        return this.gangable;
    }

    public boolean isBunkable() {
        return this.bunkable;
    }

    public boolean useCenteredCommon() {
        return this == CREW;
    }

    public boolean useShortBlanket() {
        return this == CREW;
    }

    public boolean hasCustomPillow() {
        return this == CREW;
    }

    public boolean hasCustomMattress() {
        return this == CREW;
    }

    public boolean hasTopper() {
        return this == CREW;
    }

    public boolean hasComboModels() {
        return this == CREW || this == FUTURE;
    }

    public String getBaseType() {
        return this.baseType.name().toLowerCase();
    }

    public static EnumBedStyle byName(String name) {
        for (EnumBedStyle entry : EnumBedStyle.values()) {
            if (!entry.getString().equalsIgnoreCase(name)) continue;
            return entry;
        }
        return COT;
    }

    public static EnumBedStyle byIndex(int index) {
        EnumBedStyle[] values = EnumBedStyle.values();
        return index < 0 || index >= values.length ? COT : values[index];
    }

    public static EnumBedStyle byBlock(Block block) {
        return block instanceof BlockMultiBed ? ((BlockMultiBed)block).getBedStyle() : COT;
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnumBedStyle::values);
    }

    private static enum BaseType {
        SLAT,
        FLAT,
        NONE;

    }
}

