/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import com.google.common.base.Strings;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.ByteArrayOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Objects;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.apache.commons.lang3.tuple.Pair;
import shetiphian.multibeds.common.misc.Palettes;

public record Embroidery(byte palette, byte[] indices) {
    public static final Embroidery EMPTY = new Embroidery(0, new byte[0]);
    public static final Codec<Embroidery> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("share_tag").forGetter(rec$ -> ((Embroidery)rec$).buildShareTag(new String[0]))).apply((Applicative)instance, Embroidery::fromShareTag));
    public static final StreamCodec<FriendlyByteBuf, Embroidery> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, Embroidery>(){

        public void encode(FriendlyByteBuf buffer, Embroidery embroidery) {
            if (embroidery == EMPTY) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                buffer.writeByte(embroidery.palette);
                buffer.writeByteArray(embroidery.indices);
            }
        }

        public Embroidery decode(FriendlyByteBuf buffer) {
            if (buffer.readBoolean()) {
                try {
                    return Embroidery.fromUncompressed(buffer.readByte(), Embroidery.decompressArtwork(buffer.readByteArray()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return EMPTY;
        }
    };

    public boolean isEmpty() {
        return this.indices.length == 0;
    }

    public static Embroidery fromUncompressed(byte palette, byte[] uncompressed) {
        byte[] indices = Embroidery.getBaseCanvasArraySize(uncompressed) == -1 ? Arrays.copyOf(uncompressed, 256) : uncompressed;
        return new Embroidery(palette, (byte[])Embroidery.compressArtWork(indices).getValue());
    }

    public byte[] getUncompressedIndices() {
        byte[] uncompressed = Embroidery.decompressArtwork(this.indices);
        if (Embroidery.getBaseCanvasArraySize(uncompressed) == -1) {
            return Arrays.copyOf(uncompressed, 256);
        }
        return uncompressed;
    }

    public static Embroidery fromShareTag(String shareTag) {
        if (Strings.isNullOrEmpty((String)shareTag)) {
            return EMPTY;
        }
        byte palette = 0;
        String imageData = shareTag;
        if (shareTag.contains(":")) {
            int index;
            String[] split = shareTag.split(":");
            int partCount = split.length;
            imageData = split[partCount - 1].replaceAll(" ", "");
            boolean skip = !split[0].startsWith("#");
            int n = index = skip ? 1 : 0;
            while (index < partCount - 1) {
                if (split[index].startsWith("#")) {
                    String number = split[index].substring(1);
                    try {
                        palette = number.startsWith("-") ? (byte)(~Byte.parseByte(number.substring(1), 16)) : Byte.parseByte(number, 16);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++index;
            }
        }
        byte[] indices = new byte[]{};
        try {
            if (imageData.startsWith("0x")) {
                indices = new byte[imageData.length() / 2 - 1];
                for (int index = 2; index < imageData.length(); index += 2) {
                    indices[index / 2 - 1] = (byte)Integer.parseInt(imageData.substring(index, index + 2), 16);
                }
            } else {
                indices = Base64.getDecoder().decode(imageData);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Embroidery.getBaseCanvasArraySize(Embroidery.decompressArtwork(indices)) > -1) {
            return new Embroidery(palette, indices);
        }
        return EMPTY;
    }

    public static String getNameFromShareTag(String shareTag) {
        String name = "";
        if (!Strings.isNullOrEmpty((String)shareTag) && shareTag.contains(":") && !shareTag.startsWith("#")) {
            return shareTag.substring(0, shareTag.indexOf(":"));
        }
        return name;
    }

    public String buildShareTag(String ... prefix) {
        StringBuilder builder = new StringBuilder();
        for (String data : prefix) {
            builder.append(data).append(":");
        }
        if (this.palette != 0) {
            builder.append("#").append((String)(this.palette < 0 ? "-" + Integer.toHexString(~this.palette) : Integer.toHexString(this.palette))).append(":");
        }
        builder.append(Base64.getEncoder().encodeToString(this.indices));
        return builder.toString();
    }

    public static Embroidery fromNbtTag(CompoundTag tag) {
        if (tag.contains("compressed") && tag.contains("indices")) {
            return Embroidery.fromUncompressed(tag.getByte("palette"), tag.getBoolean("compressed") ? Embroidery.decompressArtwork(tag.getByteArray("indices")) : tag.getByteArray("indices"));
        }
        return EMPTY;
    }

    public void writeToNbt(CompoundTag tag) {
        Embroidery.writeToNbt(tag, this.palette(), this.getUncompressedIndices());
    }

    private static void writeToNbt(CompoundTag tag, byte palette, byte[] uncompressed) {
        Pair<Boolean, byte[]> result = Embroidery.compressArtWork(uncompressed);
        tag.putBoolean("compressed", ((Boolean)result.getKey()).booleanValue());
        tag.putByteArray("indices", (byte[])result.getValue());
        tag.putByte("palette", palette);
    }

    public static void removeFromNbt(CompoundTag tag) {
        tag.remove("compressed");
        tag.remove("indices");
        tag.remove("palette");
    }

    private static Pair<Boolean, byte[]> compressArtWork(byte[] artwork) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compressor.setInput(artwork);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(artwork.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (Exception count) {
            // empty catch block
        }
        byte[] compressed = bos.toByteArray();
        return compressed.length < artwork.length ? Pair.of((Object)true, (Object)compressed) : Pair.of((Object)false, (Object)artwork);
    }

    private static byte[] decompressArtwork(byte[] compressed) {
        if (compressed.length == 0) {
            return compressed;
        }
        Inflater decompressor = new Inflater();
        decompressor.setInput(compressed);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(compressed.length);
        byte[] buf = new byte[1024];
        while (!decompressor.finished()) {
            try {
                int count = decompressor.inflate(buf);
                bos.write(buf, 0, count);
            }
            catch (DataFormatException e) {
                return compressed;
            }
        }
        try {
            bos.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bos.toByteArray();
    }

    public static int getCanvasScale(byte[] indices) {
        return (int)Math.sqrt(Embroidery.getBaseCanvasArraySize(indices));
    }

    public static int getBaseCanvasArraySize(byte[] indices) {
        return switch (indices.length) {
            case 144, 162 -> 144;
            case 256, 288 -> 256;
            case 576, 648 -> 576;
            case 1024, 1152 -> 1024;
            default -> -1;
        };
    }

    public static int getColorAt(byte palette, byte[] indices, int index) {
        int canvasSize = Embroidery.getBaseCanvasArraySize(indices);
        if (canvasSize > -1 && index >= 0 && index <= canvasSize - 1) {
            boolean alpha = false;
            int alphaIndex = canvasSize + index / 8;
            if (indices.length > alphaIndex) {
                byte alphaByte = indices[alphaIndex];
                int bitShift = 7 - index % 8;
                alpha = (alphaByte >> bitShift & 1) == 1;
            }
            return Palettes.getColorFor(palette, indices[index] & 0xFF, alpha);
        }
        return 0xFFFFFF;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Embroidery)) return false;
        Embroidery other = (Embroidery)obj;
        if (this.palette != other.palette) return false;
        if (!Arrays.equals(this.indices, other.indices)) return false;
        return true;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.palette, Arrays.hashCode(this.indices));
    }
}

