/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.misc;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class BiomeTexture {
    private static final Map<String, Block> BIOME_TEXTURE = new HashMap<String, Block>();
    private static final ItemStack DEFAULT = new ItemStack((ItemLike)Blocks.OAK_PLANKS);

    public static ItemStack getStackFor(Holder<Biome> biomeRegistryEntry) {
        ResourceLocation identifier;
        Optional keyOptional;
        if (biomeRegistryEntry != null && (keyOptional = biomeRegistryEntry.unwrapKey()).isPresent() && (identifier = ((ResourceKey)keyOptional.get()).location()) != null) {
            String key = identifier.toString();
            if (!BIOME_TEXTURE.containsKey(key)) {
                Block block = BiomeTexture.getBlockFor(identifier);
                if (block == null) {
                    block = BiomeTexture.getBlockFor(biomeRegistryEntry);
                }
                BIOME_TEXTURE.put(key, block);
            }
            return new ItemStack((ItemLike)BIOME_TEXTURE.getOrDefault(key, Blocks.OAK_PLANKS));
        }
        return DEFAULT.copy();
    }

    private static Block getBlockFor(ResourceLocation biome) {
        if (biome != null && "minecraft".equals(biome.getNamespace())) {
            switch (biome.getPath()) {
                case "the_void": {
                    return Blocks.END_STONE;
                }
                case "plains": {
                    return Blocks.OAK_PLANKS;
                }
                case "sunflower_plains": {
                    return Blocks.OAK_PLANKS;
                }
                case "snowy_plains": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "ice_spikes": {
                    return Blocks.PACKED_ICE;
                }
                case "desert": {
                    return Blocks.SANDSTONE;
                }
                case "swamp": {
                    return Blocks.OAK_PLANKS;
                }
                case "forest": {
                    return Blocks.BIRCH_PLANKS;
                }
                case "flower_forest": {
                    return Blocks.BIRCH_PLANKS;
                }
                case "birch_forest": {
                    return Blocks.BIRCH_PLANKS;
                }
                case "dark_forest": {
                    return Blocks.DARK_OAK_PLANKS;
                }
                case "old_growth_birch_forest": {
                    return Blocks.BIRCH_PLANKS;
                }
                case "old_growth_pine_taiga": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "old_growth_spruce_taiga": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "taiga": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "snowy_taiga": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "savanna": {
                    return Blocks.ACACIA_PLANKS;
                }
                case "savanna_plateau": {
                    return Blocks.ACACIA_PLANKS;
                }
                case "windswept_hills": {
                    return Blocks.OAK_PLANKS;
                }
                case "windswept_gravelly_hills": {
                    return Blocks.OAK_PLANKS;
                }
                case "windswept_forest": {
                    return Blocks.OAK_PLANKS;
                }
                case "windswept_savanna": {
                    return Blocks.ACACIA_PLANKS;
                }
                case "jungle": {
                    return Blocks.JUNGLE_PLANKS;
                }
                case "sparse_jungle": {
                    return Blocks.JUNGLE_PLANKS;
                }
                case "bamboo_jungle": {
                    return Blocks.JUNGLE_PLANKS;
                }
                case "badlands": {
                    return Blocks.TERRACOTTA;
                }
                case "eroded_badlands": {
                    return Blocks.TERRACOTTA;
                }
                case "wooded_badlands": {
                    return Blocks.TERRACOTTA;
                }
                case "meadow": {
                    return Blocks.BIRCH_PLANKS;
                }
                case "grove": {
                    return Blocks.SPRUCE_PLANKS;
                }
                case "snowy_slopes": {
                    return Blocks.SNOW_BLOCK;
                }
                case "frozen_peaks": {
                    return Blocks.PACKED_ICE;
                }
                case "jagged_peaks": {
                    return Blocks.ICE;
                }
                case "stony_peaks": {
                    return Blocks.STONE;
                }
                case "river": {
                    return Blocks.CLAY;
                }
                case "frozen_river": {
                    return Blocks.ICE;
                }
                case "beach": {
                    return Blocks.STONE;
                }
                case "snowy_beach": {
                    return Blocks.STONE;
                }
                case "stony_shore": {
                    return Blocks.STONE;
                }
                case "warm_ocean": {
                    return Blocks.HORN_CORAL_BLOCK;
                }
                case "lukewarm_ocean": {
                    return Blocks.STONE;
                }
                case "deep_lukewarm_ocean": {
                    return Blocks.PRISMARINE_BRICKS;
                }
                case "ocean": {
                    return Blocks.STONE;
                }
                case "deep_ocean": {
                    return Blocks.PRISMARINE_BRICKS;
                }
                case "cold_ocean": {
                    return Blocks.STONE;
                }
                case "deep_cold_ocean": {
                    return Blocks.PRISMARINE_BRICKS;
                }
                case "frozen_ocean": {
                    return Blocks.ICE;
                }
                case "deep_frozen_ocean": {
                    return Blocks.BLUE_ICE;
                }
                case "mushroom_fields": {
                    return Blocks.MUSHROOM_STEM;
                }
                case "dripstone_caves": {
                    return Blocks.DRIPSTONE_BLOCK;
                }
                case "lush_caves": {
                    return Blocks.OAK_PLANKS;
                }
                case "nether_wastes": {
                    return Blocks.NETHERRACK;
                }
                case "warped_forest": {
                    return Blocks.WARPED_PLANKS;
                }
                case "crimson_forest": {
                    return Blocks.CRIMSON_PLANKS;
                }
                case "soul_sand_valley": {
                    return Blocks.SOUL_SAND;
                }
                case "basalt_deltas": {
                    return Blocks.BASALT;
                }
                case "the_end": {
                    return Blocks.END_STONE;
                }
                case "end_highlands": {
                    return Blocks.END_STONE;
                }
                case "end_midlands": {
                    return Blocks.END_STONE;
                }
                case "small_end_islands": {
                    return Blocks.END_STONE;
                }
                case "end_barrens": {
                    return Blocks.END_STONE;
                }
            }
        }
        return null;
    }

    private static Block getBlockFor(Holder<Biome> biome) {
        if (biome != null) {
            AtomicReference<Block> result = new AtomicReference<Block>();
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_OCEAN) ? Blocks.STONE : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_BEACH) ? Blocks.STONE : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_RIVER) ? Blocks.CLAY : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_MOUNTAIN) ? Blocks.STONE : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_BADLANDS) ? Blocks.RED_SANDSTONE : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_TAIGA) ? Blocks.SPRUCE_PLANKS : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_JUNGLE) ? Blocks.JUNGLE_PLANKS : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_FOREST) ? Blocks.BIRCH_PLANKS : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_SAVANNA) ? Blocks.ACACIA_PLANKS : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_OVERWORLD) ? Blocks.OAK_PLANKS : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_NETHER) ? Blocks.NETHERRACK : null));
            result.compareAndExchange((Block)null, (Block)(biome.is(BiomeTags.IS_END) ? Blocks.END_STONE : null));
            result.compareAndExchange(null, Blocks.OAK_PLANKS);
            return (Block)result.get();
        }
        return Blocks.OAK_PLANKS;
    }
}

