/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.ItemBlanket;
import shetiphian.multibeds.common.item.ItemEmbroideryThread;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public interface TagData {
    default public boolean getMirrored(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ((Bedding)stack.getOrDefault((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)Bedding.EMPTY)).mirrored();
        }
        return false;
    }

    default public boolean hasArt(ItemStack stack) {
        ItemStack blanket = this.getBlanket(stack);
        return !blanket.isEmpty() && ItemEmbroideryThread.getArtwork(blanket) != EnumSpreadArt.NONE;
    }

    default public ItemStack getArt(ItemStack stack) {
        ItemStack blanket = this.getBlanket(stack);
        return !blanket.isEmpty() && ItemEmbroideryThread.getArtwork(blanket) != EnumSpreadArt.NONE ? blanket : ItemStack.EMPTY;
    }

    default public ItemStack getBlanket(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ((Bedding)stack.getOrDefault((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)Bedding.EMPTY)).blanket();
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack getPillow(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ((Bedding)stack.getOrDefault((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)Bedding.EMPTY)).pillow();
        }
        return ItemStack.EMPTY;
    }

    default public ItemStack getSheet(ItemStack stack) {
        if (!stack.isEmpty()) {
            return ((Bedding)stack.getOrDefault((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)Bedding.EMPTY)).sheet();
        }
        return ItemStack.EMPTY;
    }

    default public void addInformation(ItemStack stack, List<Component> tooltip) {
        Item item;
        ItemStack sheet;
        ItemStack pillow;
        Object pattern;
        ItemStack blanket = this.getBlanket(stack);
        if (!blanket.isEmpty()) {
            Item item2 = blanket.getItem();
            if (item2 instanceof ItemBlanket) {
                ItemBlanket itemBlanket = (ItemBlanket)item2;
                DyeColor color = itemBlanket.getColor(blanket);
                pattern = ItemBlanket.getPatternName(blanket);
                if (((String)pattern).equalsIgnoreCase("plain")) {
                    tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o + ").append((Component)Component.translatable((String)("color." + color.getName()))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"item.multibeds.blanket")));
                } else {
                    tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o + ").append((Component)Component.translatable((String)("color." + color.getName()))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)("misc.multibeds.pattern." + (String)pattern))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"item.multibeds.blanket")));
                }
            } else if (blanket.getItem() instanceof BannerItem) {
                tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o + ").append(blanket.getDisplayName()));
            }
            EnumSpreadArt art = ItemEmbroideryThread.getArtwork(blanket);
            if (art != EnumSpreadArt.NONE) {
                tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o * ").append((Component)Component.translatable((String)"misc.multibeds.art")).append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("misc.multibeds.art." + art.getSerializedName()))));
            }
        }
        if (!(pillow = this.getPillow(stack)).isEmpty() && (pattern = pillow.getItem()) instanceof ItemBedCustomization) {
            ItemBedCustomization pillowItem = (ItemBedCustomization)((Object)pattern);
            DyeColor color = pillowItem.getColor(pillow);
            tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o + ").append((Component)Component.translatable((String)("color." + color.getName()))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"item.multibeds.pillow")));
        }
        if (!(sheet = this.getSheet(stack)).isEmpty() && (item = sheet.getItem()) instanceof ItemBedCustomization) {
            ItemBedCustomization sheetItem = (ItemBedCustomization)item;
            DyeColor color = sheetItem.getColor(sheet);
            tooltip.add((Component)Component.literal((String)"\u00a77\u00a7o + ").append((Component)Component.translatable((String)("color." + color.getName()))).append((Component)Component.literal((String)" ")).append((Component)Component.translatable((String)"item.multibeds.sheet")));
        }
    }
}

