/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import com.google.common.base.Strings;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import shetiphian.core.common.rgb16.RGB16StackHelper;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.component.Artwork;
import shetiphian.multibeds.common.component.Bedding;
import shetiphian.multibeds.common.component.Texture;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumBlanket;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

class StackMigrationHelper {
    StackMigrationHelper() {
    }

    private static ItemStack extractStack(CompoundTag tag, String key) {
        ItemStack stack = ItemStack.EMPTY;
        if (tag.contains(key, 10)) {
            CompoundTag tagStack = tag.getCompound(key);
            if (tagStack.contains("id", 8)) {
                try {
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tagStack.getString("id")));
                    stack = new ItemStack((ItemLike)item);
                    if (!stack.isEmpty() && tagStack.contains("tag", 10)) {
                        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tagStack.getCompound("tag")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            tag.remove(key);
        }
        return stack;
    }

    static void migrateTextures(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            ItemStack texture = StackMigrationHelper.extractStack(tag, "texture_item");
            if (tag.contains("BlockEntityTag", 10)) {
                CompoundTag blockTag = tag.getCompound("BlockEntityTag");
                ItemStack itemStack = texture = texture.isEmpty() ? StackMigrationHelper.extractStack(blockTag, "texture_item") : texture;
                if (blockTag.isEmpty()) {
                    tag.remove("BlockEntityTag");
                }
            }
            if (!texture.isEmpty()) {
                stack.set((DataComponentType)Roster.Components.TEXTURE_DATA.get(), (Object)new Texture(texture));
            }
            if (tag.isEmpty()) {
                stack.remove(DataComponents.CUSTOM_DATA);
            }
        }
    }

    static void migrateBedding(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            ItemStack blanket = StackMigrationHelper.extractStack(tag, "blanket");
            ItemStack pillow = StackMigrationHelper.extractStack(tag, "pillow");
            ItemStack sheet = StackMigrationHelper.extractStack(tag, "sheet");
            if (tag.contains("BlockEntityTag", 10)) {
                CompoundTag blockTag = tag.getCompound("BlockEntityTag");
                blanket = blanket.isEmpty() ? StackMigrationHelper.extractStack(tag, "blanket_item") : blanket;
                pillow = pillow.isEmpty() ? StackMigrationHelper.extractStack(tag, "pillow_item") : pillow;
                ItemStack itemStack = sheet = sheet.isEmpty() ? StackMigrationHelper.extractStack(tag, "sheet_item") : sheet;
                if (blockTag.isEmpty()) {
                    tag.remove("BlockEntityTag");
                }
            }
            StackMigrationHelper.migrateBlanket(blanket);
            StackMigrationHelper.migrateRGB16(pillow);
            StackMigrationHelper.migrateRGB16(sheet);
            if (!(blanket.isEmpty() && pillow.isEmpty() && sheet.isEmpty())) {
                boolean mirrored = !blanket.isEmpty() & tag.getBoolean("mirror");
                stack.set((DataComponentType)Roster.Components.BEDDING_DATA.get(), (Object)new Bedding(blanket, pillow, sheet, mirrored));
            }
            tag.remove("mirror");
            if (tag.isEmpty()) {
                stack.remove(DataComponents.CUSTOM_DATA);
            }
        }
    }

    static void migrateBlanket(ItemStack stack) {
        if (stack.has(DataComponents.CUSTOM_DATA)) {
            CompoundTag tag = ((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
            if (tag.contains("pattern")) {
                EnumBlanket.Pattern pattern;
                String patternName = tag.getString("pattern");
                if (!Strings.isNullOrEmpty((String)patternName) && (pattern = EnumBlanket.Pattern.byName(patternName)) != EnumBlanket.Pattern.PLAIN) {
                    stack.set((DataComponentType)Roster.Components.PATTERN_DATA.get(), (Object)pattern);
                }
                tag.remove("pattern");
            }
            CompoundTag tagArtwork = tag;
            if (stack.getItem() instanceof BannerItem && tag.contains("BlockEntityTag", 10)) {
                CompoundTag blockTag = tag.getCompound("BlockEntityTag");
                if (tag.contains("ForgeData", 10)) {
                    CompoundTag forgeTag = tag.getCompound("ForgeData");
                    tagArtwork = forgeTag.copy();
                    forgeTag.remove("artwork");
                    forgeTag.remove("indices");
                    forgeTag.remove("compressed");
                    forgeTag.remove("palette");
                    if (forgeTag.isEmpty()) {
                        tag.remove("ForgeData");
                    }
                }
                if (blockTag.isEmpty()) {
                    tag.remove("BlockEntityTag");
                }
            }
            EnumSpreadArt art = EnumSpreadArt.NONE;
            if (tagArtwork.contains("artwork")) {
                art = EnumSpreadArt.byName(tagArtwork.getString("artwork"));
                tagArtwork.remove("artwork");
            }
            Embroidery embroidery = Embroidery.EMPTY;
            if (tagArtwork.contains("indices")) {
                embroidery = Embroidery.fromNbtTag(tagArtwork);
                tagArtwork.remove("indices");
                tagArtwork.remove("compressed");
                tagArtwork.remove("palette");
            }
            EnumSpreadArt enumSpreadArt = !embroidery.isEmpty() ? EnumSpreadArt.CUSTOM : (art = art == EnumSpreadArt.CUSTOM ? EnumSpreadArt.NONE : art);
            if (art != EnumSpreadArt.NONE) {
                stack.set((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)new Artwork(art, embroidery));
            }
            if (tag.isEmpty()) {
                stack.remove(DataComponents.CUSTOM_DATA);
            }
        }
    }

    static void migrateRGB16(ItemStack stack) {
        RGB16StackHelper.migrate((ItemStack)stack);
    }
}

