/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import shetiphian.core.SideExecutor;
import shetiphian.core.common.IColored;
import shetiphian.core.common.ITabFiller;
import shetiphian.core.common.rgb16.IRGB16;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.ImmutableRGB16;
import shetiphian.core.common.rgb16.RGB16Helper;
import shetiphian.multibeds.common.item.ItemBedCustomization;
import shetiphian.multibeds.common.item.StackMigrationHelper;

public class ItemPillowSheet
extends ItemBedCustomization
implements ITabFiller,
IRGB16_Item {
    public ItemPillowSheet(Item.Properties properties, ItemBedCustomization.EnumType type) {
        super(properties, DyeColor.WHITE, type);
    }

    public void fillCreativeTab(CreativeModeTab.Output entries, CreativeModeTab.ItemDisplayParameters context) {
        for (DyeColor color : DyeColor.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            this.setRGB16(stack, (IRGB16)new ImmutableRGB16(color.getName()));
            entries.accept(stack);
        }
    }

    public void verifyComponentsAfterLoad(ItemStack stack) {
        super.verifyComponentsAfterLoad(stack);
        if (SideExecutor.isLogicalServer()) {
            StackMigrationHelper.migrateRGB16(stack);
        }
    }

    @Override
    public DyeColor getColor(ItemStack stack) {
        return RGB16Helper.getDyeColor((short)this.getRGB16(stack).getIndex());
    }

    public int getRenderColor(ItemStack stack) {
        if (!stack.isEmpty()) {
            IRGB16 rgb16 = this.getRGB16(stack);
            if (rgb16 != null) {
                return rgb16.getColor();
            }
            return this.getColor(stack).getTextureDiffuseColor();
        }
        return -1;
    }

    @Override
    public int getColorFor(IColored.Data data, int index) {
        if (!data.stack.isEmpty()) {
            return this.getRenderColor(data.stack);
        }
        return super.getColorFor(data, index);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.literal((String)RGB16Helper.getTooltip((short)this.getRGB16(stack).getIndex())));
        super.appendHoverText(stack, context, tooltip, flag);
    }

    public boolean enableDyeRecipe(ItemStack stack) {
        return true;
    }

    public boolean dyeUseChance(ItemStack stack) {
        return true;
    }

    public double getDyeUseChance(ItemStack result, ItemStack dye, int dyeCounter) {
        if (result.getItem() == this && this.getRGB16(result).getIndex() == this.getStartingIndex(result)) {
            return 1.0;
        }
        return Math.max(0.0, 1.0 - 0.15 * (double)dyeCounter);
    }
}

