/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.multibeds.common.item;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import shetiphian.core.SideExecutor;
import shetiphian.core.client.ClientHelpers;
import shetiphian.core.common.item.IDamageHandler;
import shetiphian.multibeds.MultiBeds;
import shetiphian.multibeds.Roster;
import shetiphian.multibeds.common.component.Artwork;
import shetiphian.multibeds.common.misc.Embroidery;
import shetiphian.multibeds.common.misc.EnumSpreadArt;

public class ItemEmbroideryThread
extends Item
implements IDamageHandler {
    public ItemEmbroideryThread(Item.Properties properties) {
        super(properties.durability(25));
        SideExecutor.runOnClient(() -> () -> ClientHelpers.addProperty((Item)this, (String)"fill", (stack, world, entity, number) -> {
            float value = (float)((double)stack.getDamageValue() / (double)stack.getMaxDamage());
            return stack.getMaxDamage() - stack.getDamageValue() <= 1 ? 0.0f : Math.max(0.1f, 1.0f - value);
        }));
    }

    public int onDamaged(ItemStack stack, int dmgAmount, ServerLevel world, ServerPlayer player) {
        return stack.getDamageValue() + 1 < stack.getMaxDamage() ? 1 : 0;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        MultiBeds.SIDE_HANDLER.openGuiEmbroidery(player, stack, world, null);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public InteractionResult useOn(UseOnContext data) {
        ItemStack stack = data.getItemInHand();
        MultiBeds.SIDE_HANDLER.openGuiEmbroidery(data.getPlayer(), stack, data.getLevel(), data.getClickedPos());
        return InteractionResult.SUCCESS;
    }

    public static void setArtwork(ItemStack stack, EnumSpreadArt art, Embroidery embroidery) {
        if (!stack.isEmpty()) {
            if (art != EnumSpreadArt.NONE) {
                stack.set((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)new Artwork(art, embroidery));
            } else {
                stack.set((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)Artwork.EMPTY);
            }
        }
    }

    public static EnumSpreadArt getArtwork(ItemStack stack) {
        return stack.isEmpty() ? EnumSpreadArt.NONE : ((Artwork)stack.getOrDefault((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)Artwork.EMPTY)).art();
    }

    public static Embroidery getArtworkEmbroidery(ItemStack stack) {
        return stack.isEmpty() ? Embroidery.EMPTY : ((Artwork)stack.getOrDefault((DataComponentType)Roster.Components.ARTWORK_DATA.get(), (Object)Artwork.EMPTY)).embroidery();
    }

    public static String getArtName(ItemStack stack) {
        return ItemEmbroideryThread.getArtwork(stack).getSerializedName();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        if (!stack.isEmpty()) {
            ItemEmbroideryThread.addArtToTooltip(tooltip, stack);
        }
    }

    public static void addArtToTooltip(List<Component> tooltip, ItemStack stack) {
        EnumSpreadArt artwork;
        if (!stack.isEmpty() && (artwork = ItemEmbroideryThread.getArtwork(stack)) != EnumSpreadArt.NONE) {
            tooltip.add((Component)Component.translatable((String)"misc.multibeds.art").append((Component)Component.literal((String)": ")).append((Component)Component.translatable((String)("misc.multibeds.art." + artwork.getSerializedName()))));
        }
    }
}

